/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal.aggregation;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.AggregationTranslator;
import com.liferay.portal.search.aggregation.FieldAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.aggregation.BaseAggregationTranslator;
import com.liferay.portal.search.elasticsearch7.internal.script.ScriptTranslator;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public class BaseFieldAggregationTranslator {
    private final BaseAggregationTranslator _baseAggregationTranslator = new BaseAggregationTranslator();
    private final ScriptTranslator _scriptTranslator = new ScriptTranslator();

    public <T extends ValuesSourceAggregationBuilder> T translate(ValuesSourceAggregationBuilderFactory<T> valuesSourceAggregationBuilderFactory, FieldAggregation baseFieldAggregation, AggregationTranslator<AggregationBuilder> aggregationTranslator, PipelineAggregationTranslator<PipelineAggregationBuilder> pipelineAggregationTranslator) {
        T valuesSourceAggregationBuilder = valuesSourceAggregationBuilderFactory.create(baseFieldAggregation);
        this.setField(valuesSourceAggregationBuilder, baseFieldAggregation);
        this.setMissing(valuesSourceAggregationBuilder, baseFieldAggregation);
        this.setScript(valuesSourceAggregationBuilder, baseFieldAggregation);
        this._baseAggregationTranslator.translate((AggregationBuilder)valuesSourceAggregationBuilder, (Aggregation)baseFieldAggregation, aggregationTranslator, pipelineAggregationTranslator);
        return valuesSourceAggregationBuilder;
    }

    protected <T extends ValuesSourceAggregationBuilder> void setField(T valuesSourceAggregationBuilder, FieldAggregation baseFieldAggregation) {
        if (baseFieldAggregation.getField() != null) {
            valuesSourceAggregationBuilder.field(baseFieldAggregation.getField());
        }
    }

    protected <T extends ValuesSourceAggregationBuilder> void setMissing(T valuesSourceAggregationBuilder, FieldAggregation baseFieldAggregation) {
        if (baseFieldAggregation.getMissing() != null) {
            valuesSourceAggregationBuilder.missing(baseFieldAggregation.getMissing());
        }
    }

    protected <T extends ValuesSourceAggregationBuilder> void setScript(T valuesSourceAggregationBuilder, FieldAggregation baseFieldAggregation) {
        if (baseFieldAggregation.getScript() != null) {
            Script elasticsearchScript = this._scriptTranslator.translate(baseFieldAggregation.getScript());
            valuesSourceAggregationBuilder.script(elasticsearchScript);
        }
    }

    public static interface ValuesSourceAggregationBuilderFactory<T extends ValuesSourceAggregationBuilder> {
        public T create(FieldAggregation var1);
    }
}

