/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch7.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineConfigurator;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.SearchEngineProxyWrapper;
import com.liferay.portal.kernel.search.messaging.BaseSearchEngineMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchReaderMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchWriterMessageListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class BaseSearchEngineConfigurator
implements SearchEngineConfigurator {
    private static final int _INDEX_SEARCH_WRITER_MAX_QUEUE_SIZE = GetterUtil.getInteger((String)PropsUtil.get((String)"index.search.writer.max.queue.size"));
    private static final Log _log = LogFactoryUtil.getLog(BaseSearchEngineConfigurator.class);
    private DestinationServiceRegistrarHelper _destinationServiceRegistrarHelper = new DestinationServiceRegistrarHelperImpl(this);
    private final Map<String, DestinationServiceRegistrar> _destinationServiceRegistrars = new ConcurrentHashMap<String, DestinationServiceRegistrar>();
    private String _originalSearchEngineId;
    private SearchDestinationHelper _searchDestinationHelper = new SearchDestinationHelperImpl(this);
    private final List<SearchEngineRegistration> _searchEngineRegistrations = new ArrayList<SearchEngineRegistration>();
    private Map<String, SearchEngine> _searchEngines;

    public void afterPropertiesSet() {
    }

    public void destroy() {
        for (SearchEngineRegistration searchEngineRegistration : this._searchEngineRegistrations) {
            this.destroySearchEngine(searchEngineRegistration);
        }
        this._searchEngineRegistrations.clear();
        if (Validator.isNotNull((String)this._originalSearchEngineId)) {
            SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
            searchEngineHelper.setDefaultSearchEngineId(this._originalSearchEngineId);
            this._originalSearchEngineId = null;
        }
        for (DestinationServiceRegistrar destinationServiceRegistrar : this._destinationServiceRegistrars.values()) {
            destinationServiceRegistrar.destroy();
        }
        this._destinationServiceRegistrars.clear();
    }

    public void setSearchEngines(Map<String, SearchEngine> searchEngines) {
        this._searchEngines = searchEngines;
    }

    protected void createSearchEngineListeners(String searchEngineId, SearchEngine searchEngine, Destination searchReaderDestination, Destination searchWriterDestination) {
        this.registerSearchEngineMessageListener(searchEngineId, searchEngine, searchReaderDestination, (BaseSearchEngineMessageListener)new SearchReaderMessageListener(), searchEngine.getIndexSearcher());
        this.registerSearchEngineMessageListener(searchEngineId, searchEngine, searchWriterDestination, (BaseSearchEngineMessageListener)new SearchWriterMessageListener(), searchEngine.getIndexWriter());
    }

    protected Destination createSearchReaderDestination(String searchReaderDestinationName) {
        DestinationConfiguration destinationConfiguration = DestinationConfiguration.createSynchronousDestinationConfiguration((String)searchReaderDestinationName);
        DestinationFactory destinationFactory = this.getDestinationFactory();
        return destinationFactory.createDestination(destinationConfiguration);
    }

    protected Destination createSearchWriterDestination(String searchWriterDestinationName) {
        DestinationConfiguration destinationConfiguration = null;
        destinationConfiguration = PortalRunMode.isTestMode() ? DestinationConfiguration.createSynchronousDestinationConfiguration((String)searchWriterDestinationName) : DestinationConfiguration.createParallelDestinationConfiguration((String)searchWriterDestinationName);
        if (_INDEX_SEARCH_WRITER_MAX_QUEUE_SIZE > 0) {
            destinationConfiguration.setMaximumQueueSize(_INDEX_SEARCH_WRITER_MAX_QUEUE_SIZE);
            ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(4);
                        sb.append("The search index writer's task queue ");
                        sb.append("is at its maximum capacity. The ");
                        sb.append("current thread will handle the ");
                        sb.append("request.");
                        _log.warn((Object)sb.toString());
                    }
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            };
            destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        }
        DestinationFactory destinationFactory = this.getDestinationFactory();
        return destinationFactory.createDestination(destinationConfiguration);
    }

    protected void destroySearchEngine(SearchEngineRegistration searchEngineRegistration) {
        Destination searchWriterDestination;
        MessageBus messageBus = this.getMessageBus();
        Destination searchReaderDestination = this.getSearchReaderDestination(messageBus, searchEngineRegistration.getSearchEngineId(), false);
        if (searchReaderDestination != null) {
            searchReaderDestination.unregisterMessageListeners();
        }
        if ((searchWriterDestination = this.getSearchWriterDestination(messageBus, searchEngineRegistration.getSearchEngineId(), false)) != null) {
            searchWriterDestination.unregisterMessageListeners();
        }
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        searchEngineHelper.removeSearchEngine(searchEngineRegistration.getSearchEngineId());
        if (!searchEngineRegistration.isOverride()) {
            DestinationServiceRegistrar destinationServiceRegistrar = this._destinationServiceRegistrars.remove(searchEngineRegistration.getSearchEngineId());
            if (destinationServiceRegistrar != null) {
                destinationServiceRegistrar.destroy();
            }
            return;
        }
        SearchEngineProxyWrapper originalSearchEngineProxy = searchEngineRegistration.getOriginalSearchEngineProxyWrapper();
        if (searchReaderDestination != null) {
            this.registerInvokerMessageListener(searchReaderDestination, searchEngineRegistration.getOriginalSearchReaderMessageListeners());
        }
        if (searchWriterDestination != null) {
            this.registerInvokerMessageListener(searchWriterDestination, searchEngineRegistration.getOriginalSearchWriterMessageListeners());
        }
        this.setSearchEngine(searchEngineRegistration.getSearchEngineId(), (SearchEngine)originalSearchEngineProxy);
    }

    protected abstract BundleContext getBundleContext();

    protected abstract String getDefaultSearchEngineId();

    protected Destination getDestination(ServiceRegistration<Destination> serviceRegistration) {
        BundleContext bundleContext = this.getBundleContext();
        return (Destination)bundleContext.getService(serviceRegistration.getReference());
    }

    protected abstract DestinationFactory getDestinationFactory();

    protected abstract IndexSearcher getIndexSearcher();

    protected abstract IndexWriter getIndexWriter();

    protected abstract MessageBus getMessageBus();

    @Deprecated
    protected ClassLoader getOperatingClassloader() {
        return this.getOperatingClassLoader();
    }

    protected abstract ClassLoader getOperatingClassLoader();

    protected abstract SearchEngineHelper getSearchEngineHelper();

    protected Destination getSearchReaderDestination(MessageBus messageBus, String searchEngineId, boolean createIfAbsent) {
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        String searchReaderDestinationName = searchEngineHelper.getSearchReaderDestinationName(searchEngineId);
        Destination searchReaderDestination = messageBus.getDestination(searchReaderDestinationName);
        if (createIfAbsent && searchReaderDestination == null) {
            searchReaderDestination = this._searchDestinationHelper.createSearchReaderDestination(searchReaderDestinationName);
            this._registerSearchEngineDestination(searchEngineId, searchReaderDestination);
        }
        return searchReaderDestination;
    }

    protected Destination getSearchWriterDestination(MessageBus messageBus, String searchEngineId, boolean createIfAbsent) {
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        String searchWriterDestinationName = searchEngineHelper.getSearchWriterDestinationName(searchEngineId);
        Destination searchWriterDestination = messageBus.getDestination(searchWriterDestinationName);
        if (createIfAbsent && searchWriterDestination == null) {
            searchWriterDestination = this._searchDestinationHelper.createSearchWriterDestination(searchWriterDestinationName);
            this._registerSearchEngineDestination(searchEngineId, searchWriterDestination);
        }
        return searchWriterDestination;
    }

    protected void initialize() {
        Set<Map.Entry<String, SearchEngine>> entrySet = this._searchEngines.entrySet();
        for (Map.Entry<String, SearchEngine> entry : entrySet) {
            this.initSearchEngine(entry.getKey(), entry.getValue());
        }
        String defaultSearchEngineId = this.getDefaultSearchEngineId();
        if (Validator.isNotNull((String)defaultSearchEngineId)) {
            SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
            this._originalSearchEngineId = searchEngineHelper.getDefaultSearchEngineId();
            searchEngineHelper.setDefaultSearchEngineId(defaultSearchEngineId);
        }
        this._searchEngines.clear();
    }

    protected void initSearchEngine(String searchEngineId, SearchEngine searchEngine) {
        SearchEngineRegistration searchEngineRegistration = new SearchEngineRegistration(searchEngineId);
        this._searchEngineRegistrations.add(searchEngineRegistration);
        MessageBus messageBus = this.getMessageBus();
        Destination searchReaderDestination = this.getSearchReaderDestination(messageBus, searchEngineId, true);
        searchEngineRegistration.setSearchReaderDestinationName(searchReaderDestination.getName());
        Destination searchWriterDestination = this.getSearchWriterDestination(messageBus, searchEngineId, true);
        searchEngineRegistration.setSearchWriterDestinationName(searchWriterDestination.getName());
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        SearchEngine originalSearchEngine = searchEngineHelper.getSearchEngineSilent(searchEngineId);
        if (originalSearchEngine != null) {
            searchEngineRegistration.setOverride(true);
            searchEngineRegistration.setOriginalSearchEngineProxyWrapper((SearchEngineProxyWrapper)originalSearchEngine);
            this.savePreviousSearchEngineListeners(searchReaderDestination, searchWriterDestination, searchEngineRegistration);
            searchReaderDestination.unregisterMessageListeners();
            searchWriterDestination.unregisterMessageListeners();
        }
        this.createSearchEngineListeners(searchEngineId, searchEngine, searchReaderDestination, searchWriterDestination);
        SearchEngineProxyWrapper searchEngineProxyWrapper = new SearchEngineProxyWrapper(searchEngine, this.getIndexSearcher(), this.getIndexWriter());
        this.setSearchEngine(searchEngineId, (SearchEngine)searchEngineProxyWrapper);
    }

    protected ServiceRegistration<Destination> registerDestination(Destination destination) {
        BundleContext bundleContext = this.getBundleContext();
        return bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    protected void registerInvokerMessageListener(Destination destination, List<InvokerMessageListener> invokerMessageListeners) {
        for (InvokerMessageListener invokerMessageListener : invokerMessageListeners) {
            destination.register(invokerMessageListener.getMessageListener(), invokerMessageListener.getClassLoader());
        }
    }

    protected void registerSearchEngineMessageListener(String searchEngineId, SearchEngine searchEngine, Destination destination, BaseSearchEngineMessageListener baseSearchEngineMessageListener, Object manager) {
        baseSearchEngineMessageListener.setManager(manager);
        baseSearchEngineMessageListener.setMessageBus(this.getMessageBus());
        baseSearchEngineMessageListener.setSearchEngine(searchEngine);
        baseSearchEngineMessageListener.setSearchEngineId(searchEngineId);
        destination.register((MessageListener)baseSearchEngineMessageListener, this.getOperatingClassLoader());
    }

    protected void savePreviousSearchEngineListeners(Destination searchReaderDestination, Destination searchWriterDestination, SearchEngineRegistration searchEngineRegistration) {
        Set searchReaderMessageListeners = searchReaderDestination.getMessageListeners();
        for (MessageListener searchReaderMessageListener : searchReaderMessageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)searchReaderMessageListener;
            searchEngineRegistration.addOriginalSearchReaderMessageListener(invokerMessageListener);
        }
        Set searchWriterMessageListeners = searchWriterDestination.getMessageListeners();
        for (MessageListener searchWriterMessageListener : searchWriterMessageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)searchWriterMessageListener;
            searchEngineRegistration.addOriginalSearchWriterMessageListener(invokerMessageListener);
        }
    }

    protected void setDestinationServiceRegistrarHelper(DestinationServiceRegistrarHelper destinationServiceRegistrarHelper) {
        this._destinationServiceRegistrarHelper = destinationServiceRegistrarHelper;
    }

    protected void setSearchDestinationHelper(SearchDestinationHelper searchDestinationHelper) {
        this._searchDestinationHelper = searchDestinationHelper;
    }

    protected void setSearchEngine(String searchEngineId, SearchEngine searchEngine) {
        SearchEngineHelper searchEngineHelper = this.getSearchEngineHelper();
        searchEngineHelper.setSearchEngine(searchEngineId, searchEngine);
        searchEngine.initialize(0L);
    }

    private void _registerSearchEngineDestination(String searchEngineId, Destination destination) {
        HashMap properties = HashMapBuilder.put((Object)"destination.name", (Object)destination.getName()).build();
        DestinationServiceRegistrar destinationServiceRegistrar = this._destinationServiceRegistrars.get(searchEngineId);
        if (destinationServiceRegistrar == null) {
            destinationServiceRegistrar = new DestinationServiceRegistrar(this._destinationServiceRegistrarHelper);
            this._destinationServiceRegistrars.put(searchEngineId, destinationServiceRegistrar);
        }
        destinationServiceRegistrar.registerService(Destination.class, destination, properties);
    }

    private static class SearchEngineRegistration {
        private SearchEngineProxyWrapper _originalSearchEngineProxyWrapper;
        private final List<InvokerMessageListener> _originalSearchReaderMessageListeners = new ArrayList<InvokerMessageListener>();
        private final List<InvokerMessageListener> _originalSearchWriterMessageListeners = new ArrayList<InvokerMessageListener>();
        private boolean _override;
        private final String _searchEngineId;
        private String _searchReaderDestinationName;
        private String _searchWriterDestinationName;

        public void addOriginalSearchReaderMessageListener(InvokerMessageListener messageListener) {
            this._originalSearchReaderMessageListeners.add(messageListener);
        }

        public void addOriginalSearchWriterMessageListener(InvokerMessageListener messageListener) {
            this._originalSearchWriterMessageListeners.add(messageListener);
        }

        public SearchEngineProxyWrapper getOriginalSearchEngineProxyWrapper() {
            return this._originalSearchEngineProxyWrapper;
        }

        public List<InvokerMessageListener> getOriginalSearchReaderMessageListeners() {
            return this._originalSearchReaderMessageListeners;
        }

        public List<InvokerMessageListener> getOriginalSearchWriterMessageListeners() {
            return this._originalSearchWriterMessageListeners;
        }

        public String getSearchEngineId() {
            return this._searchEngineId;
        }

        public String getSearchReaderDestinationName() {
            return this._searchReaderDestinationName;
        }

        public String getSearchWriterDestinationName() {
            return this._searchWriterDestinationName;
        }

        public boolean isOverride() {
            return this._override;
        }

        public void setOriginalSearchEngineProxyWrapper(SearchEngineProxyWrapper searchEngineProxyWrapper) {
            this._originalSearchEngineProxyWrapper = searchEngineProxyWrapper;
        }

        public void setOverride(boolean override) {
            this._override = override;
        }

        public void setSearchReaderDestinationName(String searchReaderDestinationName) {
            this._searchReaderDestinationName = searchReaderDestinationName;
        }

        public void setSearchWriterDestinationName(String searchWriterDestinationName) {
            this._searchWriterDestinationName = searchWriterDestinationName;
        }

        private SearchEngineRegistration(String searchEngineId) {
            this._searchEngineId = searchEngineId;
        }
    }

    private static class SearchDestinationHelperImpl
    implements SearchDestinationHelper {
        private final BaseSearchEngineConfigurator _baseSearchEngineConfigurator;

        @Override
        public Destination createSearchReaderDestination(String searchReaderDestinationName) {
            return this._baseSearchEngineConfigurator.createSearchReaderDestination(searchReaderDestinationName);
        }

        @Override
        public Destination createSearchWriterDestination(String searchWriterDestinationName) {
            return this._baseSearchEngineConfigurator.createSearchWriterDestination(searchWriterDestinationName);
        }

        private SearchDestinationHelperImpl(BaseSearchEngineConfigurator baseSearchEngineConfigurator) {
            this._baseSearchEngineConfigurator = baseSearchEngineConfigurator;
        }
    }

    private static class DestinationServiceRegistrarHelperImpl
    implements DestinationServiceRegistrarHelper {
        private final BaseSearchEngineConfigurator _baseSearchEngineConfigurator;

        @Override
        public Destination getDestination(ServiceRegistration<Destination> serviceRegistration) {
            return this._baseSearchEngineConfigurator.getDestination(serviceRegistration);
        }

        @Override
        public ServiceRegistration<Destination> registerDestination(Destination destination) {
            return this._baseSearchEngineConfigurator.registerDestination(destination);
        }

        private DestinationServiceRegistrarHelperImpl(BaseSearchEngineConfigurator baseSearchEngineConfigurator) {
            this._baseSearchEngineConfigurator = baseSearchEngineConfigurator;
        }
    }

    private static class DestinationServiceRegistrar {
        private final DestinationServiceRegistrarHelper _destinationServiceRegistrarHelper;
        private final Set<ServiceRegistration<Destination>> _serviceRegistrations = new HashSet<ServiceRegistration<Destination>>();

        public synchronized void destroy() {
            for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations) {
                Destination destination = this._destinationServiceRegistrarHelper.getDestination(serviceRegistration);
                serviceRegistration.unregister();
                destination.destroy();
            }
            this._serviceRegistrations.clear();
        }

        public synchronized void registerService(Class<Destination> clazz, Destination destination, Map<String, Object> properties) {
            this._serviceRegistrations.add(this._destinationServiceRegistrarHelper.registerDestination(destination));
        }

        private DestinationServiceRegistrar(DestinationServiceRegistrarHelper destinationServiceRegistrarHelper) {
            this._destinationServiceRegistrarHelper = destinationServiceRegistrarHelper;
        }
    }

    public static interface SearchDestinationHelper {
        public Destination createSearchReaderDestination(String var1);

        public Destination createSearchWriterDestination(String var1);
    }

    public static interface DestinationServiceRegistrarHelper {
        public Destination getDestination(ServiceRegistration<Destination> var1);

        public ServiceRegistration<Destination> registerDestination(Destination var1);
    }
}

