/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.sort;

import com.liferay.portal.search.elasticsearch6.internal.geolocation.DistanceUnitTranslator;
import com.liferay.portal.search.elasticsearch6.internal.geolocation.GeoDistanceTypeTranslator;
import com.liferay.portal.search.elasticsearch6.internal.geolocation.GeoLocationPointTranslator;
import com.liferay.portal.search.elasticsearch6.internal.script.ScriptTranslator;
import com.liferay.portal.search.query.QueryTranslator;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.GeoDistanceSort;
import com.liferay.portal.search.sort.NestedSort;
import com.liferay.portal.search.sort.ScoreSort;
import com.liferay.portal.search.sort.ScriptSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldTranslator;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.SortVisitor;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortMode;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Elasticsearch"}, service={SortFieldTranslator.class, SortVisitor.class})
public class ElasticsearchSortFieldTranslator
implements SortFieldTranslator<SortBuilder>,
SortVisitor<SortBuilder> {
    private final DistanceUnitTranslator _distanceUnitTranslator = new DistanceUnitTranslator();
    private final GeoDistanceTypeTranslator _geoDistanceTypeTranslator = new GeoDistanceTypeTranslator();
    private QueryTranslator<QueryBuilder> _queryTranslator;
    private final ScriptTranslator _scriptTranslator = new ScriptTranslator();

    public SortBuilder translate(Sort sort) {
        return (SortBuilder)sort.accept((SortVisitor)this);
    }

    public SortBuilder visit(FieldSort fieldSort) {
        FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)fieldSort.getField());
        fieldSortBuilder.order(this.translate(fieldSort.getSortOrder()));
        if (fieldSort.getMissing() != null) {
            fieldSortBuilder.missing(fieldSort.getMissing());
        }
        if (fieldSort.getNestedSort() != null) {
            fieldSortBuilder.setNestedSort(this.translate(fieldSort.getNestedSort()));
        }
        if (fieldSort.getSortMode() != null) {
            fieldSortBuilder.sortMode(this.translate(fieldSort.getSortMode()));
        }
        return fieldSortBuilder.unmappedType("keyword");
    }

    public SortBuilder visit(GeoDistanceSort geoDistanceSort) {
        List geoLocationPoints = geoDistanceSort.getGeoLocationPoints();
        Stream stream = geoLocationPoints.stream();
        GeoDistanceSortBuilder geoDistanceSortBuilder = SortBuilders.geoDistanceSort((String)geoDistanceSort.getField(), (GeoPoint[])((GeoPoint[])stream.map(GeoLocationPointTranslator::translate).toArray(GeoPoint[]::new)));
        if (geoDistanceSort.getDistanceUnit() != null) {
            geoDistanceSortBuilder.unit(this._distanceUnitTranslator.translate(geoDistanceSort.getDistanceUnit()));
        }
        if (geoDistanceSort.getGeoDistanceType() != null) {
            GeoDistance geoDistance = this._geoDistanceTypeTranslator.translate(geoDistanceSort.getGeoDistanceType());
            geoDistanceSortBuilder.geoDistance(geoDistance);
        }
        if (geoDistanceSort.getNestedSort() != null) {
            geoDistanceSortBuilder.setNestedSort(this.translate(geoDistanceSort.getNestedSort()));
        }
        if (geoDistanceSort.getSortMode() != null) {
            geoDistanceSortBuilder.sortMode(this.translate(geoDistanceSort.getSortMode()));
        }
        return geoDistanceSortBuilder;
    }

    public SortBuilder visit(ScoreSort scoreSort) {
        return SortBuilders.scoreSort();
    }

    public SortBuilder visit(ScriptSort scriptSort) {
        Script script = this._scriptTranslator.translate(scriptSort.getScript());
        ScriptSortBuilder.ScriptSortType scriptSortType = ScriptSortBuilder.ScriptSortType.NUMBER;
        if (scriptSort.getScriptSortType() == ScriptSort.ScriptSortType.STRING) {
            scriptSortType = ScriptSortBuilder.ScriptSortType.STRING;
        }
        ScriptSortBuilder scriptSortBuilder = SortBuilders.scriptSort((Script)script, (ScriptSortBuilder.ScriptSortType)scriptSortType);
        if (scriptSort.getNestedSort() != null) {
            scriptSortBuilder.setNestedSort(this.translate(scriptSort.getNestedSort()));
        }
        if (scriptSort.getSortMode() != null) {
            scriptSortBuilder.sortMode(this.translate(scriptSort.getSortMode()));
        }
        return scriptSortBuilder;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setQueryTranslator(QueryTranslator<QueryBuilder> queryTranslator) {
        this._queryTranslator = queryTranslator;
    }

    protected NestedSortBuilder translate(NestedSort nestedSort) {
        NestedSortBuilder nestedSortBuilder = new NestedSortBuilder(nestedSort.getPath());
        if (nestedSort.getFilterQuery() != null) {
            QueryBuilder queryBuilder = (QueryBuilder)this._queryTranslator.translate(nestedSort.getFilterQuery());
            nestedSortBuilder.setFilter(queryBuilder);
        }
        if (nestedSort.getNestedSort() != null) {
            NestedSort childNestedSort = nestedSort.getNestedSort();
            nestedSortBuilder.setNestedSort(this.translate(childNestedSort));
        }
        nestedSortBuilder.setMaxChildren(nestedSort.getMaxChildren());
        return nestedSortBuilder;
    }

    protected SortMode translate(com.liferay.portal.search.sort.SortMode sortMode) {
        if (sortMode == com.liferay.portal.search.sort.SortMode.AVG) {
            return SortMode.AVG;
        }
        if (sortMode == com.liferay.portal.search.sort.SortMode.MAX) {
            return SortMode.MAX;
        }
        if (sortMode == com.liferay.portal.search.sort.SortMode.MEDIAN) {
            return SortMode.MEDIAN;
        }
        if (sortMode == com.liferay.portal.search.sort.SortMode.MIN) {
            return SortMode.MIN;
        }
        if (sortMode == com.liferay.portal.search.sort.SortMode.SUM) {
            return SortMode.SUM;
        }
        throw new IllegalArgumentException("Invalid sort mode: " + sortMode);
    }

    protected org.elasticsearch.search.sort.SortOrder translate(SortOrder sortOrder) {
        if (sortOrder == SortOrder.ASC || sortOrder == null) {
            return org.elasticsearch.search.sort.SortOrder.ASC;
        }
        if (sortOrder == SortOrder.DESC) {
            return org.elasticsearch.search.sort.SortOrder.DESC;
        }
        throw new IllegalArgumentException("Invalid sort order: " + sortOrder);
    }
}

