/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot.DeleteSnapshotRequestExecutor;
import com.liferay.portal.search.engine.adapter.snapshot.DeleteSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.DeleteSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DeleteSnapshotRequestExecutor.class})
public class DeleteSnapshotRequestExecutorImpl
implements DeleteSnapshotRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public DeleteSnapshotResponse execute(DeleteSnapshotRequest deleteSnapshotRequest) {
        DeleteSnapshotRequestBuilder deleteSnapshotRequestBuilder = this.createDeleteSnapshotRequestBuilder(deleteSnapshotRequest);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)deleteSnapshotRequestBuilder.get();
        return new DeleteSnapshotResponse(acknowledgedResponse.isAcknowledged());
    }

    protected DeleteSnapshotRequestBuilder createDeleteSnapshotRequestBuilder(DeleteSnapshotRequest deleteSnapshotRequest) {
        DeleteSnapshotRequestBuilder deleteSnapshotRequestBuilder = DeleteSnapshotAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(false));
        deleteSnapshotRequestBuilder.setRepository(deleteSnapshotRequest.getRepositoryName());
        deleteSnapshotRequestBuilder.setSnapshot(deleteSnapshotRequest.getSnapshotName());
        return deleteSnapshotRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

