/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot.CreateSnapshotRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot.SnapshotInfoConverter;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotResponse;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotDetails;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CreateSnapshotRequestExecutor.class})
public class CreateSnapshotRequestExecutorImpl
implements CreateSnapshotRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public CreateSnapshotResponse execute(CreateSnapshotRequest createSnapshotRequest) {
        CreateSnapshotRequestBuilder createSnapshotRequestBuilder = this.createCreateSnapshotRequestBuilder(createSnapshotRequest);
        org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse elasticsearchCreateSnapshotResponse = (org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse)createSnapshotRequestBuilder.get();
        SnapshotDetails snapshotDetails = SnapshotInfoConverter.convert(elasticsearchCreateSnapshotResponse.getSnapshotInfo());
        return new CreateSnapshotResponse(snapshotDetails);
    }

    protected CreateSnapshotRequestBuilder createCreateSnapshotRequestBuilder(CreateSnapshotRequest createSnapshotRequest) {
        CreateSnapshotRequestBuilder createSnapshotRequestBuilder = CreateSnapshotAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(false));
        if (ArrayUtil.isNotEmpty((Object[])createSnapshotRequest.getIndexNames())) {
            createSnapshotRequestBuilder.setIndices(createSnapshotRequest.getIndexNames());
        }
        createSnapshotRequestBuilder.setRepository(createSnapshotRequest.getRepositoryName());
        createSnapshotRequestBuilder.setSnapshot(createSnapshotRequest.getSnapshotName());
        createSnapshotRequestBuilder.setWaitForCompletion(createSnapshotRequest.isWaitForCompletion());
        return createSnapshotRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

