/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot.CreateSnapshotRepositoryRequestExecutor;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRepositoryRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRepositoryResponse;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.fs.FsRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CreateSnapshotRepositoryRequestExecutor.class})
public class CreateSnapshotRepositoryRequestExecutorImpl
implements CreateSnapshotRepositoryRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public CreateSnapshotRepositoryResponse execute(CreateSnapshotRepositoryRequest createSnapshotRepositoryRequest) {
        PutRepositoryRequestBuilder putRepositoryRequestBuilder = this.createPutRepositoryRequestBuilder(createSnapshotRepositoryRequest);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)putRepositoryRequestBuilder.get();
        return new CreateSnapshotRepositoryResponse(acknowledgedResponse.isAcknowledged());
    }

    protected PutRepositoryRequestBuilder createPutRepositoryRequestBuilder(CreateSnapshotRepositoryRequest createSnapshotRepositoryRequest) {
        PutRepositoryRequestBuilder putRepositoryRequestBuilder = PutRepositoryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(false));
        putRepositoryRequestBuilder.setName(createSnapshotRepositoryRequest.getName());
        Settings.Builder builder = Settings.builder();
        builder.put(FsRepository.COMPRESS_SETTING.getKey(), createSnapshotRepositoryRequest.isCompress());
        builder.put(FsRepository.LOCATION_SETTING.getKey(), createSnapshotRepositoryRequest.getLocation());
        putRepositoryRequestBuilder.setSettings(builder);
        putRepositoryRequestBuilder.setType(createSnapshotRepositoryRequest.getType());
        putRepositoryRequestBuilder.setVerify(createSnapshotRepositoryRequest.isVerify());
        return putRepositoryRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

