/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchSearchRequestExecutor.class})
public class SearchSearchRequestExecutorImpl
implements SearchSearchRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(SearchSearchRequestExecutorImpl.class);
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private SearchSearchRequestAssembler _searchSearchRequestAssembler;
    private SearchSearchResponseAssembler _searchSearchResponseAssembler;

    @Override
    public SearchSearchResponse execute(SearchSearchRequest searchSearchRequest) {
        SearchRequestBuilder searchRequestBuilder = SearchAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(searchSearchRequest.isPreferLocalCluster()));
        this._searchSearchRequestAssembler.assemble(searchRequestBuilder, searchSearchRequest);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        SearchSearchResponse searchSearchResponse = new SearchSearchResponse();
        this._searchSearchResponseAssembler.assemble(searchRequestBuilder, searchResponse, searchSearchRequest, searchSearchResponse);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", searchSearchResponse.getSearchRequestString(), " in ", searchSearchResponse.getExecutionTime(), " ms"}));
        }
        return searchSearchResponse;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setSearchSearchRequestAssembler(SearchSearchRequestAssembler searchSearchRequestAssembler) {
        this._searchSearchRequestAssembler = searchSearchRequestAssembler;
    }

    @Reference(unbind="-")
    protected void setSearchSearchResponseAssembler(SearchSearchResponseAssembler searchSearchResponseAssembler) {
        this._searchSearchResponseAssembler = searchSearchResponseAssembler;
    }
}

