/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.OpenIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndicesOptions;
import com.liferay.portal.search.engine.adapter.index.OpenIndexRequest;
import com.liferay.portal.search.engine.adapter.index.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenIndexRequestExecutor.class})
public class OpenIndexRequestExecutorImpl
implements OpenIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private IndicesOptionsTranslator _indicesOptionsTranslator;

    @Override
    public OpenIndexResponse execute(OpenIndexRequest openIndexRequest) {
        OpenIndexRequestBuilder openIndexRequestBuilder = this.createOpenIndexRequestBuilder(openIndexRequest);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)openIndexRequestBuilder.get();
        return new OpenIndexResponse(acknowledgedResponse.isAcknowledged());
    }

    protected OpenIndexRequestBuilder createOpenIndexRequestBuilder(OpenIndexRequest openIndexRequest) {
        OpenIndexRequestBuilder openIndexRequestBuilder = OpenIndexAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(false));
        openIndexRequestBuilder.setIndices(openIndexRequest.getIndexNames());
        IndicesOptions indicesOptions = openIndexRequest.getIndicesOptions();
        if (indicesOptions != null) {
            openIndexRequestBuilder.setIndicesOptions(this._indicesOptionsTranslator.translate(indicesOptions));
        }
        if (openIndexRequest.getTimeout() > 0L) {
            TimeValue timeValue = TimeValue.timeValueMillis((long)openIndexRequest.getTimeout());
            openIndexRequestBuilder.setMasterNodeTimeout(timeValue);
            openIndexRequestBuilder.setTimeout(timeValue);
        }
        if (openIndexRequest.getWaitForActiveShards() > 0) {
            openIndexRequestBuilder.setWaitForActiveShards(openIndexRequest.getWaitForActiveShards());
        }
        return openIndexRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setIndicesOptionsTranslator(IndicesOptionsTranslator indicesOptionsTranslator) {
        this._indicesOptionsTranslator = indicesOptionsTranslator;
    }
}

