/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndicesExistsIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsAction;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IndicesExistsIndexRequestExecutor.class})
public class IndicesExistsIndexRequestExecutorImpl
implements IndicesExistsIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public IndicesExistsIndexResponse execute(IndicesExistsIndexRequest indicesExistsIndexRequest) {
        IndicesExistsRequestBuilder indicesExistsRequestBuilder = this.createIndicesExistsRequestBuilder(indicesExistsIndexRequest);
        IndicesExistsResponse indicesExistsResponse = (IndicesExistsResponse)indicesExistsRequestBuilder.get();
        return new IndicesExistsIndexResponse(indicesExistsResponse.isExists());
    }

    protected IndicesExistsRequestBuilder createIndicesExistsRequestBuilder(IndicesExistsIndexRequest indicesExistsIndexRequest) {
        IndicesExistsRequestBuilder indicesExistsRequestBuilder = IndicesExistsAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(indicesExistsIndexRequest.isPreferLocalCluster()));
        indicesExistsRequestBuilder.setIndices(indicesExistsIndexRequest.getIndexNames());
        return indicesExistsRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

