/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.io.StringOutputStream;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.AnalyzeIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.AnalysisIndexResponseToken;
import com.liferay.portal.search.engine.adapter.index.AnalyzeIndexRequest;
import com.liferay.portal.search.engine.adapter.index.AnalyzeIndexResponse;
import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequestBuilder;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.admin.indices.analyze.DetailAnalyzeResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyzeIndexRequestExecutor.class})
public class AnalyzeIndexRequestExecutorImpl
implements AnalyzeIndexRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(AnalyzeIndexRequestExecutorImpl.class);
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public AnalyzeIndexResponse execute(AnalyzeIndexRequest analyzeIndexRequest) {
        AnalyzeRequestBuilder analyzeRequestBuilder = this.createAnalyzeRequestBuilder(analyzeIndexRequest);
        AnalyzeResponse analyzeResponse = (AnalyzeResponse)analyzeRequestBuilder.get();
        AnalyzeIndexResponse analyzeIndexResponse = new AnalyzeIndexResponse();
        for (AnalyzeResponse.AnalyzeToken analyzeToken : analyzeResponse.getTokens()) {
            AnalysisIndexResponseToken analysisIndexResponseToken = new AnalysisIndexResponseToken(analyzeToken.getTerm());
            analysisIndexResponseToken.setAttributes(analyzeToken.getAttributes());
            analysisIndexResponseToken.setEndOffset(analyzeToken.getEndOffset());
            analysisIndexResponseToken.setPosition(analyzeToken.getPosition());
            analysisIndexResponseToken.setPositionLength(analyzeToken.getPositionLength());
            analysisIndexResponseToken.setStartOffset(analyzeToken.getStartOffset());
            analysisIndexResponseToken.setType(analyzeToken.getType());
            analyzeIndexResponse.addAnalysisIndexResponseTokens(analysisIndexResponseToken);
        }
        this.processDetailAnalyzeResponse(analyzeIndexResponse, analyzeResponse.detail());
        return analyzeIndexResponse;
    }

    protected AnalyzeRequestBuilder createAnalyzeRequestBuilder(AnalyzeIndexRequest analyzeIndexRequest) {
        AnalyzeRequestBuilder analyzeRequestBuilder = AnalyzeAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(true));
        if (Validator.isNotNull((String)analyzeIndexRequest.getAnalyzer())) {
            analyzeRequestBuilder.setAnalyzer(analyzeIndexRequest.getAnalyzer());
        }
        analyzeRequestBuilder.setAttributes(analyzeIndexRequest.getAttributesArray());
        analyzeRequestBuilder.setExplain(analyzeIndexRequest.isExplain());
        if (Validator.isNotNull((String)analyzeIndexRequest.getFieldName())) {
            analyzeRequestBuilder.setField(analyzeIndexRequest.getFieldName());
        }
        analyzeRequestBuilder.setIndex(analyzeIndexRequest.getIndexName());
        if (Validator.isNotNull((String)analyzeIndexRequest.getNormalizer())) {
            analyzeRequestBuilder.setNormalizer(analyzeIndexRequest.getNormalizer());
        }
        analyzeRequestBuilder.setText(analyzeIndexRequest.getTexts());
        if (Validator.isNotNull((String)analyzeIndexRequest.getTokenizer())) {
            analyzeRequestBuilder.setTokenizer(analyzeIndexRequest.getTokenizer());
        }
        for (String charFilter : analyzeIndexRequest.getCharFilters()) {
            analyzeRequestBuilder.addCharFilter(charFilter);
        }
        for (String tokenFilter : analyzeIndexRequest.getTokenFilters()) {
            analyzeRequestBuilder.addTokenFilter(tokenFilter);
        }
        return analyzeRequestBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDetailAnalyzeResponse(AnalyzeIndexResponse analyzeIndexResponse, DetailAnalyzeResponse detailAnalyzeResponse) {
        if (detailAnalyzeResponse != null) {
            StringOutputStream stringOutputStream = new StringOutputStream();
            OutputStreamStreamOutput outputStreamStreamOutput = new OutputStreamStreamOutput((OutputStream)stringOutputStream);
            try {
                detailAnalyzeResponse.writeTo((StreamOutput)outputStreamStreamOutput);
                outputStreamStreamOutput.flush();
            }
            catch (IOException ioException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)ioException, (Throwable)ioException);
                }
            }
            finally {
                block14: {
                    try {
                        outputStreamStreamOutput.close();
                    }
                    catch (IOException ioException) {
                        if (!_log.isDebugEnabled()) break block14;
                        _log.debug((Object)ioException, (Throwable)ioException);
                    }
                }
            }
            analyzeIndexResponse.setAnalysisDetails(stringOutputStream.toString());
        }
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

