/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.document.ElasticsearchDocumentFactory;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document.ElasticsearchBulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.GetDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Elasticsearch"}, service={BulkableDocumentRequestTranslator.class, ElasticsearchBulkableDocumentRequestTranslator.class})
public class ElasticsearchBulkableDocumentRequestTranslatorImpl
implements ElasticsearchBulkableDocumentRequestTranslator {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private ElasticsearchDocumentFactory _elasticsearchDocumentFactory;

    @Override
    public DeleteRequestBuilder translate(DeleteDocumentRequest deleteDocumentRequest) {
        Client client = this._elasticsearchClientResolver.getClient(false);
        DeleteRequestBuilder deleteRequestBuilder = client.prepareDelete();
        this._setRefreshPolicy((WriteRequestBuilder)deleteRequestBuilder, deleteDocumentRequest.isRefresh());
        return ((DeleteRequestBuilder)deleteRequestBuilder.setId(deleteDocumentRequest.getUid()).setIndex(deleteDocumentRequest.getIndexName())).setType(this._getType(deleteDocumentRequest.getType()));
    }

    @Override
    public GetRequestBuilder translate(GetDocumentRequest getDocumentRequest) {
        Client client = this._elasticsearchClientResolver.getClient(getDocumentRequest.isPreferLocalCluster());
        GetRequestBuilder getRequestBuilder = client.prepareGet();
        return ((GetRequestBuilder)getRequestBuilder.setId(getDocumentRequest.getId()).setIndex(getDocumentRequest.getIndexName())).setRefresh(getDocumentRequest.isRefresh()).setFetchSource(getDocumentRequest.getFetchSourceIncludes(), getDocumentRequest.getFetchSourceExcludes()).setStoredFields(getDocumentRequest.getStoredFields()).setType(this._getType(getDocumentRequest.getType()));
    }

    @Override
    public IndexRequestBuilder translate(IndexDocumentRequest indexDocumentRequest) {
        Client client = this._elasticsearchClientResolver.getClient(false);
        IndexRequestBuilder indexRequestBuilder = client.prepareIndex();
        this._setRefreshPolicy((WriteRequestBuilder)indexRequestBuilder, indexDocumentRequest.isRefresh());
        this._setSource(indexRequestBuilder, indexDocumentRequest);
        return ((IndexRequestBuilder)indexRequestBuilder.setId(this._getUid(indexDocumentRequest)).setIndex(indexDocumentRequest.getIndexName())).setType(this._getType(indexDocumentRequest.getType()));
    }

    @Override
    public UpdateRequestBuilder translate(UpdateDocumentRequest updateDocumentRequest) {
        Client client = this._elasticsearchClientResolver.getClient(false);
        UpdateRequestBuilder updateRequestBuilder = client.prepareUpdate();
        this._setDoc(updateRequestBuilder, updateDocumentRequest);
        this._setRefreshPolicy((WriteRequestBuilder)updateRequestBuilder, updateDocumentRequest.isRefresh());
        return ((UpdateRequestBuilder)updateRequestBuilder.setId(this._getUid(updateDocumentRequest)).setIndex(updateDocumentRequest.getIndexName())).setType(this._getType(updateDocumentRequest.getType()));
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setElasticsearchDocumentFactory(ElasticsearchDocumentFactory elasticsearchDocumentFactory) {
        this._elasticsearchDocumentFactory = elasticsearchDocumentFactory;
    }

    private String _getType(String type) {
        if (type != null) {
            return type;
        }
        return "_doc";
    }

    private String _getUid(IndexDocumentRequest indexDocumentRequest) {
        String uid = indexDocumentRequest.getUid();
        if (!Validator.isBlank((String)uid)) {
            return uid;
        }
        if (indexDocumentRequest.getDocument() != null) {
            com.liferay.portal.search.document.Document document = indexDocumentRequest.getDocument();
            return document.getString("uid");
        }
        Document document = indexDocumentRequest.getDocument71();
        Field field = document.getField("uid");
        if (field != null) {
            return field.getValue();
        }
        return uid;
    }

    private String _getUid(UpdateDocumentRequest updateDocumentRequest) {
        String uid = updateDocumentRequest.getUid();
        if (!Validator.isBlank((String)uid)) {
            return uid;
        }
        if (updateDocumentRequest.getDocument() != null) {
            com.liferay.portal.search.document.Document document = updateDocumentRequest.getDocument();
            return document.getString("uid");
        }
        Document document = updateDocumentRequest.getDocument71();
        Field field = document.getField("uid");
        if (field != null) {
            uid = field.getValue();
        }
        return uid;
    }

    private void _setDoc(UpdateRequestBuilder updateRequestBuilder, UpdateDocumentRequest updateDocumentRequest) {
        if (updateDocumentRequest.getDocument() != null) {
            XContentBuilder xContentBuilder = this._elasticsearchDocumentFactory.getElasticsearchDocument(updateDocumentRequest.getDocument());
            updateRequestBuilder.setDoc(xContentBuilder);
        } else {
            String elasticsearchDocument = this._elasticsearchDocumentFactory.getElasticsearchDocument(updateDocumentRequest.getDocument71());
            updateRequestBuilder.setDoc(elasticsearchDocument, XContentType.JSON);
        }
    }

    private void _setRefreshPolicy(WriteRequestBuilder writeRequestBuilder, boolean refresh) {
        if (refresh) {
            writeRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
    }

    private void _setSource(IndexRequestBuilder indexRequestBuilder, IndexDocumentRequest indexDocumentRequest) {
        if (indexDocumentRequest.getDocument() != null) {
            XContentBuilder xContentBuilder = this._elasticsearchDocumentFactory.getElasticsearchDocument(indexDocumentRequest.getDocument());
            indexRequestBuilder.setSource(xContentBuilder);
        } else {
            String elasticsearchDocument = this._elasticsearchDocumentFactory.getElasticsearchDocument(indexDocumentRequest.getDocument71());
            indexRequestBuilder.setSource(elasticsearchDocument, XContentType.JSON);
        }
    }
}

