/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster.StateClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.StateClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.StateClusterResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StateClusterRequestExecutor.class})
public class StateClusterRequestExecutorImpl
implements StateClusterRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public StateClusterResponse execute(StateClusterRequest stateClusterRequest) {
        ClusterStateRequestBuilder clusterStateRequestBuilder = this.createClusterStateRequestBuilder(stateClusterRequest);
        ClusterStateResponse clusterStateResponse = (ClusterStateResponse)clusterStateRequestBuilder.get();
        try {
            ClusterState clusterState = clusterStateResponse.getState();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            xContentBuilder.startObject();
            xContentBuilder = clusterState.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            xContentBuilder.endObject();
            return new StateClusterResponse(Strings.toString((XContentBuilder)xContentBuilder));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    protected ClusterStateRequestBuilder createClusterStateRequestBuilder(StateClusterRequest stateClusterRequest) {
        ClusterStateRequestBuilder clusterStateRequestBuilder = ClusterStateAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient(true));
        clusterStateRequestBuilder.setIndices(stateClusterRequest.getIndexNames());
        return clusterStateRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

