/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.query;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.elasticsearch6.internal.query.SimpleStringQueryTranslator;
import com.liferay.portal.search.query.Operator;
import com.liferay.portal.search.query.SimpleStringQuery;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={SimpleStringQueryTranslator.class})
public class SimpleStringQueryTranslatorImpl
implements SimpleStringQueryTranslator {
    @Override
    public QueryBuilder translate(SimpleStringQuery simpleStringQuery) {
        Map fieldBoostMap;
        SimpleQueryStringBuilder simpleQueryStringBuilder = QueryBuilders.simpleQueryStringQuery((String)simpleStringQuery.getQuery());
        if (simpleStringQuery.getAnalyzer() != null) {
            simpleQueryStringBuilder.analyzer(simpleStringQuery.getAnalyzer());
        }
        if (simpleStringQuery.getAnalyzeWildcard() != null) {
            simpleQueryStringBuilder.analyzeWildcard(simpleStringQuery.getAnalyzeWildcard().booleanValue());
        }
        if (simpleStringQuery.getAutoGenerateSynonymsPhraseQuery() != null) {
            simpleQueryStringBuilder.autoGenerateSynonymsPhraseQuery(simpleStringQuery.getAutoGenerateSynonymsPhraseQuery().booleanValue());
        }
        if (MapUtil.isNotEmpty((Map)(fieldBoostMap = simpleStringQuery.getFieldBoostMap()))) {
            Set entrySet = fieldBoostMap.entrySet();
            Stream stream = entrySet.stream();
            simpleQueryStringBuilder.fields(stream.collect(Collectors.toMap(Map.Entry::getKey, entry -> Float.valueOf(GetterUtil.getFloat(entry.getValue(), (float)1.0f)))));
        }
        if (simpleStringQuery.getDefaultOperator() != null) {
            Operator operator = simpleStringQuery.getDefaultOperator();
            if (operator == Operator.OR) {
                simpleQueryStringBuilder.defaultOperator(org.elasticsearch.index.query.Operator.OR);
            } else if (operator == Operator.AND) {
                simpleQueryStringBuilder.defaultOperator(org.elasticsearch.index.query.Operator.AND);
            } else {
                throw new IllegalArgumentException("Invalid operator: " + operator);
            }
        }
        if (simpleStringQuery.getFuzzyMaxExpansions() != null) {
            simpleQueryStringBuilder.fuzzyMaxExpansions(simpleStringQuery.getFuzzyMaxExpansions().intValue());
        }
        if (simpleStringQuery.getFuzzyPrefixLength() != null) {
            simpleQueryStringBuilder.fuzzyPrefixLength(simpleStringQuery.getFuzzyPrefixLength().intValue());
        }
        if (simpleStringQuery.getFuzzyTranspositions() != null) {
            simpleQueryStringBuilder.fuzzyTranspositions(simpleStringQuery.getFuzzyTranspositions().booleanValue());
        }
        if (simpleStringQuery.getLenient() != null) {
            simpleQueryStringBuilder.lenient(simpleStringQuery.getLenient().booleanValue());
        }
        if (simpleStringQuery.getQuoteFieldSuffix() != null) {
            simpleQueryStringBuilder.quoteFieldSuffix(simpleStringQuery.getQuoteFieldSuffix());
        }
        return simpleQueryStringBuilder;
    }
}

