/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.index;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch6.internal.settings.SettingsBuilder;
import com.liferay.portal.search.elasticsearch6.internal.util.LogUtil;
import com.liferay.portal.search.elasticsearch6.internal.util.ResourceUtil;
import com.liferay.portal.search.spi.settings.TypeMappingsHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;

public class LiferayDocumentTypeFactory
implements TypeMappingsHelper,
com.liferay.portal.search.elasticsearch6.settings.TypeMappingsHelper {
    private static final Log _log = LogFactoryUtil.getLog(LiferayDocumentTypeFactory.class);
    private final IndicesAdminClient _indicesAdminClient;
    private final JSONFactory _jsonFactory;

    public LiferayDocumentTypeFactory(IndicesAdminClient indicesAdminClient, JSONFactory jsonFactory) {
        this._indicesAdminClient = indicesAdminClient;
        this._jsonFactory = jsonFactory;
    }

    public void addTypeMappings(String indexName, String source) {
        PutMappingRequestBuilder putMappingRequestBuilder = this._indicesAdminClient.preparePutMapping(new String[]{indexName});
        putMappingRequestBuilder.setSource(this.mergeDynamicTemplates(source, indexName, "LiferayDocumentType"), XContentType.JSON);
        putMappingRequestBuilder.setType("LiferayDocumentType");
        ActionResponse actionResponse = putMappingRequestBuilder.get();
        LogUtil.logActionResponse(_log, actionResponse);
    }

    public void createLiferayDocumentTypeMappings(CreateIndexRequestBuilder createIndexRequestBuilder, String mappings) {
        createIndexRequestBuilder.addMapping("LiferayDocumentType", mappings, XContentType.JSON);
    }

    public void createOptionalDefaultTypeMappings(String indexName) {
        String name = StringUtil.replace((String)"/META-INF/mappings/liferay-type-mappings.json", (String)".json", (String)"-optional-defaults.json");
        String optionalDefaultTypeMappings = ResourceUtil.getResourceAsString(this.getClass(), name);
        this.addTypeMappings(indexName, optionalDefaultTypeMappings);
    }

    public void createRequiredDefaultAnalyzers(Settings.Builder builder) {
        SettingsBuilder settingsBuilder = new SettingsBuilder(builder);
        String requiredDefaultAnalyzers = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/index-settings.json");
        settingsBuilder.loadFromSource(requiredDefaultAnalyzers);
    }

    public void createRequiredDefaultTypeMappings(CreateIndexRequestBuilder createIndexRequestBuilder) {
        String requiredDefaultMappings = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/mappings/liferay-type-mappings.json");
        this.createLiferayDocumentTypeMappings(createIndexRequestBuilder, requiredDefaultMappings);
    }

    protected JSONObject createJSONObject(String mappings) {
        try {
            return this._jsonFactory.createJSONObject(mappings);
        }
        catch (JSONException jsonException) {
            throw new RuntimeException(jsonException);
        }
    }

    protected String getMappings(String indexName, String typeName) {
        GetMappingsRequestBuilder getMappingsRequestBuilder = this._indicesAdminClient.prepareGetMappings(new String[]{indexName});
        getMappingsRequestBuilder.setTypes(new String[]{typeName});
        GetMappingsResponse getMappingsResponse = (GetMappingsResponse)getMappingsRequestBuilder.get();
        ImmutableOpenMap map = getMappingsResponse.mappings();
        ImmutableOpenMap mappings = (ImmutableOpenMap)map.get((Object)indexName);
        MappingMetaData mappingMetaData = (MappingMetaData)mappings.get((Object)typeName);
        CompressedXContent compressedXContent = mappingMetaData.source();
        return compressedXContent.toString();
    }

    protected JSONArray merge(JSONArray jsonArray1, JSONArray jsonArray2) {
        LinkedHashMap<String, JSONObject> linkedHashMap = new LinkedHashMap<String, JSONObject>();
        this.putAll(linkedHashMap, jsonArray1);
        this.putAll(linkedHashMap, jsonArray2);
        JSONArray jsonArray3 = this._jsonFactory.createJSONArray();
        JSONObject defaultTemplateJSONObject = null;
        for (Map.Entry<String, JSONObject> entry : linkedHashMap.entrySet()) {
            String key = entry.getKey();
            if (key.equals("template_")) {
                defaultTemplateJSONObject = entry.getValue();
                continue;
            }
            jsonArray3.put(entry.getValue());
        }
        if (defaultTemplateJSONObject != null) {
            jsonArray3.put(defaultTemplateJSONObject);
        }
        return jsonArray3;
    }

    protected String mergeDynamicTemplates(String source, String indexName, String typeName) {
        JSONArray sourceTypeTemplatesJSONArray;
        JSONObject sourceJSONObject;
        JSONObject sourceTypeJSONObject = sourceJSONObject = this.createJSONObject(source);
        if (sourceJSONObject.has(typeName)) {
            sourceTypeJSONObject = sourceJSONObject.getJSONObject(typeName);
        }
        if ((sourceTypeTemplatesJSONArray = sourceTypeJSONObject.getJSONArray("dynamic_templates")) == null) {
            return sourceJSONObject.toString();
        }
        JSONObject mappingsJSONObject = this.createJSONObject(this.getMappings(indexName, typeName));
        JSONObject typeJSONObject = mappingsJSONObject.getJSONObject(typeName);
        JSONArray typeTemplatesJSONArray = typeJSONObject.getJSONArray("dynamic_templates");
        sourceTypeJSONObject.put("dynamic_templates", this.merge(typeTemplatesJSONArray, sourceTypeTemplatesJSONArray));
        return sourceJSONObject.toString();
    }

    protected void putAll(Map<String, JSONObject> map, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONArray namesJSONArray = jsonObject.names();
            String name = (String)namesJSONArray.get(0);
            map.put(name, jsonObject);
        }
    }
}

