/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.index;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexDefinitionData;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexDefinitionsHolder;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexSynchronizer;
import com.liferay.portal.search.elasticsearch6.internal.util.LogUtil;
import com.liferay.portal.search.elasticsearch6.spi.index.IndexRegistrar;
import com.liferay.portal.search.elasticsearch6.spi.index.helper.IndexSettingsDefinition;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IndexSynchronizer.class})
public class IndexSynchronizerImpl
implements IndexSynchronizer {
    private static final Log _log = LogFactoryUtil.getLog(IndexSynchronizerImpl.class);
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private IndexDefinitionsHolder _indexDefinitionsHolder;
    private final ArrayList<IndexRegistrar> _indexRegistrarContributors = new ArrayList();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void addIndexRegistrar(IndexRegistrar indexRegistrar) {
        this._indexRegistrarContributors.add(indexRegistrar);
    }

    public void removeIndexRegistrar(IndexRegistrar indexRegistrar) {
        this._indexRegistrarContributors.remove(indexRegistrar);
    }

    @Reference(unbind="-")
    public void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    public void setIndexDefinitionsHolder(IndexDefinitionsHolder indexDefinitionsHolder) {
        this._indexDefinitionsHolder = indexDefinitionsHolder;
    }

    @Override
    public void synchronizeIndexDefinition(IndexDefinitionData indexDefinitionData) {
        this.createIndex(createIndexRequestBuilder -> {
            String index = indexDefinitionData.getIndex();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Synchronizing index " + index));
            }
            createIndexRequestBuilder.setIndex(index);
            createIndexRequestBuilder.setSource(indexDefinitionData.getSource(), XContentType.JSON);
        });
    }

    @Override
    public void synchronizeIndexes() {
        ArrayList<IndexDefinitionData> list = new ArrayList<IndexDefinitionData>();
        this._indexDefinitionsHolder.drainTo(list);
        list.forEach(this::synchronizeIndexDefinition);
        this._indexRegistrarContributors.forEach(this::synchronizeIndexRegistrar);
    }

    @Override
    public void synchronizeIndexRegistrar(IndexRegistrar indexRegistrar) {
        indexRegistrar.register((indexName, indexSettingsDefinitionConsumer) -> this.createIndex(createIndexRequestBuilder -> {
            createIndexRequestBuilder.setIndex(indexName);
            indexSettingsDefinitionConsumer.accept(new IndexSettingsDefinition((CreateIndexRequestBuilder)createIndexRequestBuilder, indexSettingsDefinitionConsumer){
                final /* synthetic */ CreateIndexRequestBuilder val$createIndexRequestBuilder;
                final /* synthetic */ Consumer val$indexSettingsDefinitionConsumer;
                {
                    this.val$createIndexRequestBuilder = createIndexRequestBuilder;
                    this.val$indexSettingsDefinitionConsumer = consumer;
                }

                public void setIndexSettingsResourceName(String indexSettingsResourceName) {
                    this.val$createIndexRequestBuilder.setSource(StringUtil.read(this.val$indexSettingsDefinitionConsumer.getClass(), (String)indexSettingsResourceName), XContentType.JSON);
                }

                public void setSource(String source) {
                    this.val$createIndexRequestBuilder.setSource(source, XContentType.JSON);
                }
            });
        }));
    }

    protected void createIndex(Consumer<CreateIndexRequestBuilder> createIndexRequestBuilderConsumer) {
        block3: {
            Client client = this._elasticsearchClientResolver.getClient();
            AdminClient adminClient = client.admin();
            IndicesAdminClient indicesAdminClient = adminClient.indices();
            CreateIndexRequestBuilder createIndexRequestBuilder = indicesAdminClient.prepareCreate(null);
            createIndexRequestBuilderConsumer.accept(createIndexRequestBuilder);
            try {
                CreateIndexResponse createIndexResponse = (CreateIndexResponse)createIndexRequestBuilder.get();
                LogUtil.logActionResponse(_log, (ActionResponse)createIndexResponse);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Index created: " + createIndexResponse.index()));
                }
            }
            catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)("Skipping index creation because it already exists: " + resourceAlreadyExistsException.getIndex()), (Throwable)resourceAlreadyExistsException);
            }
        }
    }
}

