/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.groupby;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GeoDistanceSort;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.elasticsearch6.internal.groupby.GroupByTranslator;
import com.liferay.portal.search.groupby.GroupByRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHitsAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.bucketsort.BucketSortPipelineAggregationBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={GroupByTranslator.class})
public class DefaultGroupByTranslator
implements GroupByTranslator {
    private static final String _ELASTICSEARCH_SCORE_FIELD = "_score";

    @Override
    public void translate(SearchRequestBuilder searchRequestBuilder, GroupByRequest groupByRequest, Locale locale, String[] selectedFieldNames, String[] highlightFieldNames, boolean highlightEnabled, boolean highlightRequireFieldMatch, int highlightFragmentSize, int highlightSnippetSize) {
        TermsAggregationBuilder termsAggregationBuilder = AggregationBuilders.terms((String)("GroupBy_" + groupByRequest.getField()));
        termsAggregationBuilder = (TermsAggregationBuilder)termsAggregationBuilder.field(groupByRequest.getField());
        int termsSize = GetterUtil.getInteger((Object)groupByRequest.getTermsSize());
        if (termsSize > 0) {
            termsAggregationBuilder.size(termsSize);
        }
        this.addTermsSorts(termsAggregationBuilder, groupByRequest);
        int termsStart = GetterUtil.getInteger((Object)groupByRequest.getTermsStart());
        if (termsSize > 0 || termsStart > 0) {
            termsAggregationBuilder.subAggregation((PipelineAggregationBuilder)this.getBucketSortPipelineBuilder(termsStart, termsSize));
        }
        TopHitsAggregationBuilder topHitsAggregationBuilder = this.getTopHitsBuilder(groupByRequest, selectedFieldNames, locale, highlightFieldNames, highlightEnabled, highlightRequireFieldMatch, highlightFragmentSize, highlightSnippetSize);
        termsAggregationBuilder.subAggregation((AggregationBuilder)topHitsAggregationBuilder);
        searchRequestBuilder.addAggregation((AggregationBuilder)termsAggregationBuilder);
    }

    protected void addDocsSorts(TopHitsAggregationBuilder topHitsAggregationBuilder, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return;
        }
        HashSet<String> sortFieldNames = new HashSet<String>();
        for (Sort sort : sorts) {
            String sortFieldName;
            if (sort == null || sortFieldNames.contains(sortFieldName = Field.getSortFieldName((Sort)sort, (String)_ELASTICSEARCH_SCORE_FIELD))) continue;
            sortFieldNames.add(sortFieldName);
            SortOrder sortOrder = SortOrder.ASC;
            if (sort.isReverse() || sortFieldName.equals(_ELASTICSEARCH_SCORE_FIELD)) {
                sortOrder = SortOrder.DESC;
            }
            ScoreSortBuilder sortBuilder = null;
            if (sortFieldName.equals(_ELASTICSEARCH_SCORE_FIELD)) {
                sortBuilder = SortBuilders.scoreSort();
            } else if (sort.getType() == 10) {
                GeoDistanceSort geoDistanceSort = (GeoDistanceSort)sort;
                ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
                for (GeoLocationPoint geoLocationPoint : geoDistanceSort.getGeoLocationPoints()) {
                    geoPoints.add(new GeoPoint(geoLocationPoint.getLatitude(), geoLocationPoint.getLongitude()));
                }
                GeoDistanceSortBuilder geoDistanceSortBuilder = SortBuilders.geoDistanceSort((String)sortFieldName, (GeoPoint[])geoPoints.toArray(new GeoPoint[0]));
                geoDistanceSortBuilder.geoDistance(GeoDistance.ARC);
                List geoHashes = geoDistanceSort.getGeoHashes();
                if (!geoHashes.isEmpty()) {
                    geoDistanceSort.addGeoHash(geoHashes.toArray(new String[0]));
                }
                sortBuilder = geoDistanceSortBuilder;
            } else {
                FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)sortFieldName);
                fieldSortBuilder.unmappedType("keyword");
                sortBuilder = fieldSortBuilder;
            }
            sortBuilder.order(sortOrder);
            topHitsAggregationBuilder.sort((SortBuilder)sortBuilder);
        }
    }

    protected void addHighlightedField(TopHitsAggregationBuilder topHitsAggregationBuilder, HighlightBuilder highlightBuilder, Locale locale, String fieldName, int highlightFragmentSize, int highlightSnippetSize) {
        highlightBuilder.field(fieldName, highlightFragmentSize, highlightSnippetSize);
        String localizedFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        highlightBuilder.field(localizedFieldName, highlightFragmentSize, highlightSnippetSize);
        topHitsAggregationBuilder.highlighter(highlightBuilder);
    }

    protected void addHighlights(TopHitsAggregationBuilder topHitsAggregationBuilder, Locale locale, String[] highlightFieldNames, int highlightFragmentSize, int highlightSnippetSize, boolean highlightRequireFieldMatch) {
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        for (String highlightFieldName : highlightFieldNames) {
            this.addHighlightedField(topHitsAggregationBuilder, highlightBuilder, locale, highlightFieldName, highlightFragmentSize, highlightSnippetSize);
        }
        highlightBuilder.postTags(new String[]{"</liferay-hl>"});
        highlightBuilder.preTags(new String[]{"<liferay-hl>"});
        highlightBuilder.requireFieldMatch(Boolean.valueOf(highlightRequireFieldMatch));
        topHitsAggregationBuilder.highlighter(highlightBuilder);
    }

    protected void addSelectedFields(TopHitsAggregationBuilder topHitsAggregationBuilder, String[] selectedFieldNames) {
        if (ArrayUtil.isEmpty((Object[])selectedFieldNames)) {
            topHitsAggregationBuilder.storedField("*");
        } else {
            topHitsAggregationBuilder.storedFields(Arrays.asList(selectedFieldNames));
        }
    }

    protected void addTermsSorts(TermsAggregationBuilder termsAggregationBuilder, GroupByRequest groupByRequest) {
        Object[] sorts = groupByRequest.getTermsSorts();
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return;
        }
        HashSet<String> sortFieldNames = new HashSet<String>();
        ArrayList<BucketOrder> bucketOrders = new ArrayList<BucketOrder>(sorts.length);
        for (Object sort : sorts) {
            String sortFieldName;
            if (sort == null || sortFieldNames.contains(sortFieldName = sort.getFieldName())) continue;
            sortFieldNames.add(sortFieldName);
            if (sortFieldName.equals("_count")) {
                bucketOrders.add(BucketOrder.count((!sort.isReverse() ? 1 : 0) != 0));
                continue;
            }
            if (!sortFieldName.equals("_key")) continue;
            bucketOrders.add(BucketOrder.key((!sort.isReverse() ? 1 : 0) != 0));
        }
        if (!bucketOrders.isEmpty()) {
            termsAggregationBuilder.order(bucketOrders);
        }
    }

    protected BucketSortPipelineAggregationBuilder getBucketSortPipelineBuilder(int start, int size) {
        BucketSortPipelineAggregationBuilder bucketSortPipelineAggregationBuilder = new BucketSortPipelineAggregationBuilder("_bucketSort", Collections.emptyList());
        if (start > 0) {
            bucketSortPipelineAggregationBuilder.from(start);
        }
        if (size > 0) {
            bucketSortPipelineAggregationBuilder.size(Integer.valueOf(size));
        }
        return bucketSortPipelineAggregationBuilder;
    }

    protected TopHitsAggregationBuilder getTopHitsBuilder(GroupByRequest groupByRequest, String[] selectedFieldNames, Locale locale, String[] highlightFieldNames, boolean highlightEnabled, boolean highlightRequireFieldMatch, int highlightFragmentSize, int highlightSnippetSize) {
        int docsSize;
        TopHitsAggregationBuilder topHitsAggregationBuilder = AggregationBuilders.topHits((String)"_topHits");
        int docsStart = GetterUtil.getInteger((Object)groupByRequest.getDocsStart());
        if (docsStart > 0) {
            topHitsAggregationBuilder.from(docsStart);
        }
        if ((docsSize = GetterUtil.getInteger((Object)groupByRequest.getDocsSize())) > 0) {
            topHitsAggregationBuilder.size(docsSize);
        }
        this.addDocsSorts(topHitsAggregationBuilder, groupByRequest.getDocsSorts());
        if (highlightEnabled) {
            this.addHighlights(topHitsAggregationBuilder, locale, highlightFieldNames, highlightFragmentSize, highlightSnippetSize, highlightRequireFieldMatch);
        }
        this.addSelectedFields(topHitsAggregationBuilder, selectedFieldNames);
        return topHitsAggregationBuilder;
    }
}

