/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.filter;

import com.liferay.portal.kernel.search.filter.DateRangeTermFilter;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.search.elasticsearch6.internal.filter.DateRangeTermFilterTranslator;
import java.text.Format;
import java.text.ParseException;
import java.util.TimeZone;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DateRangeTermFilterTranslator.class})
public class DateRangeTermFilterTranslatorImpl
implements DateRangeTermFilterTranslator {
    @Override
    public QueryBuilder translate(DateRangeTermFilter dateRangeTermFilter) {
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)dateRangeTermFilter.getField());
        Format format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)dateRangeTermFilter.getDateFormat(), (TimeZone)dateRangeTermFilter.getTimeZone());
        try {
            rangeQueryBuilder.from(format.parseObject(dateRangeTermFilter.getLowerBound()));
            rangeQueryBuilder.includeLower(dateRangeTermFilter.isIncludesLower());
            rangeQueryBuilder.includeUpper(dateRangeTermFilter.isIncludesUpper());
            rangeQueryBuilder.to(format.parseObject(dateRangeTermFilter.getUpperBound()));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid date range " + dateRangeTermFilter, parseException);
        }
        return rangeQueryBuilder;
    }
}

