/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.connection;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.search.elasticsearch6.internal.connection.PluginJarConflictCheckSuppression;
import com.liferay.portal.search.elasticsearch6.internal.connection.PluginManager;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.collections.IteratorUtils;
import org.elasticsearch.Version;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.PluginCli;
import org.elasticsearch.plugins.PluginInfo;

public class PluginManagerImpl
implements PluginManager {
    private final Environment _environment;
    private final URL _url;

    public PluginManagerImpl(Environment environment, URL url) {
        this._environment = environment;
        this._url = url;
    }

    @Override
    public Path[] getInstalledPluginsPaths() throws IOException {
        if (!Files.exists(this._environment.pluginsFile(), new LinkOption[0])) {
            return new Path[0];
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this._environment.pluginsFile());){
            Path[] pathArray = (Path[])IteratorUtils.toArray(directoryStream.iterator(), Path.class);
            return pathArray;
        }
    }

    @Override
    public void install(String name) throws Exception {
        Settings settings = this._environment.settings();
        String[] args = new String[]{"install", "file://" + this._url.getPath(), "-Epath.home=" + settings.get("path.home"), "--batch", "--silent"};
        try {
            PluginJarConflictCheckSuppression.execute(() -> {
                try {
                    this.main(args);
                }
                catch (Exception exception) {
                    throw new SystemException((Throwable)exception);
                }
            });
        }
        catch (SystemException systemException) {
            throw (Exception)systemException.getCause();
        }
    }

    @Override
    public boolean isCurrentVersion(Path path) throws IOException {
        try {
            PluginInfo pluginInfo = PluginInfo.readFromProperties((Path)path);
            Version pluginVersion = pluginInfo.getElasticsearchVersion();
            return pluginVersion.equals((Object)Version.CURRENT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String message = illegalArgumentException.getMessage();
            if (message != null && message.contains("designed for version")) {
                return false;
            }
            throw illegalArgumentException;
        }
    }

    @Override
    public void remove(String name) throws Exception {
        Settings settings = this._environment.settings();
        this.main("remove", name, "-Epath.home=" + settings.get("path.home"), "--silent");
    }

    protected void main(String ... args) throws Exception {
        String key = "es.path.conf";
        String value = System.getProperty(key);
        if (value == null) {
            System.setProperty(key, "");
        }
        Constructor constructor = PluginCli.class.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        PluginCli pluginCli = (PluginCli)constructor.newInstance(new Object[0]);
        pluginCli.main(args, Terminal.DEFAULT);
    }
}

