/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.connection;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.configuration.CrossClusterReplicationConfigurationWrapper;
import com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch6.configuration.RESTClientLoggerLevel;
import com.liferay.portal.search.elasticsearch6.internal.connection.CCRElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionNotInitializedException;
import com.liferay.portal.search.elasticsearch6.internal.connection.MissingOperationModeException;
import com.liferay.portal.search.elasticsearch6.internal.connection.OperationMode;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration"}, immediate=true, service={ElasticsearchClientResolver.class, ElasticsearchConnectionManager.class})
public class ElasticsearchConnectionManager
implements ElasticsearchClientResolver {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected volatile CrossClusterReplicationConfigurationWrapper crossClusterReplicationConfigurationWrapper;
    @Reference(unbind="-")
    protected IndexFactory indexFactory;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchConnectionManager.class);
    private final Map<String, CCRElasticsearchConnection> _ccrElasticsearchConnections = new HashMap<String, CCRElasticsearchConnection>();
    private ClusterExecutor _clusterExecutor;
    private final Map<Long, Long> _companyIds = new HashMap<Long, Long>();
    private volatile ElasticsearchConfiguration _elasticsearchConfiguration;
    private final Map<String, ElasticsearchConnection> _elasticsearchConnections = new HashMap<String, ElasticsearchConnection>();
    private OperationMode _operationMode;

    public void activate(OperationMode operationMode) {
        this.validate(operationMode);
        this._operationMode = operationMode;
    }

    public void connect() {
        ElasticsearchConnection elasticsearchConnection = this.getElasticsearchConnection(false);
        elasticsearchConnection.connect();
    }

    public AdminClient getAdminClient() {
        Client client = this.getClient();
        return client.admin();
    }

    public ElasticsearchConnection getCCRElasticsearchConnection(String connectionId) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Getting connection with ID: " + connectionId));
        }
        return this._ccrElasticsearchConnections.get(connectionId);
    }

    @Override
    public Client getClient() {
        return this.getClient(false);
    }

    @Override
    public Client getClient(boolean preferLocalCluster) {
        return this.getClient(null, preferLocalCluster);
    }

    @Override
    public Client getClient(String connectionId, boolean preferLocalCluster) {
        ElasticsearchConnection elasticsearchConnection = this.getElasticsearchConnection(connectionId, preferLocalCluster);
        if (elasticsearchConnection == null) {
            throw new ElasticsearchConnectionNotInitializedException();
        }
        return elasticsearchConnection.getClient();
    }

    public ElasticsearchConnection getElasticsearchConnection() {
        return this.getElasticsearchConnection(false);
    }

    public ElasticsearchConnection getElasticsearchConnection(boolean preferLocalCluster) {
        return this.getElasticsearchConnection(null, preferLocalCluster);
    }

    public ElasticsearchConnection getElasticsearchConnection(String localClusterConnectionId, boolean preferLocalCluster) {
        if (this._operationMode == null) {
            return null;
        }
        if (this._operationMode == OperationMode.EMBEDDED) {
            return this._elasticsearchConnections.get("EMBEDDED");
        }
        if (preferLocalCluster && this.isCrossClusterReplicationEnabled()) {
            if (localClusterConnectionId == null) {
                localClusterConnectionId = this.getLocalClusterConnectionId();
            }
            if (localClusterConnectionId != null) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Getting local cluster connection with ID: " + localClusterConnectionId));
                }
                return this._ccrElasticsearchConnections.get(localClusterConnectionId);
            }
        }
        return this._elasticsearchConnections.get("REMOTE");
    }

    public String getLocalClusterConnectionId() {
        String[] localClusterConnectionConfigurations;
        ClusterNode localClusterNode = this._clusterExecutor.getLocalClusterNode();
        if (localClusterNode == null) {
            List<String> localClusterConnectionIds = this.getLocalClusterConnectionIds();
            return localClusterConnectionIds.get(0);
        }
        InetAddress portalInetAddress = localClusterNode.getPortalInetAddress();
        if (portalInetAddress == null) {
            return null;
        }
        String localClusterNodeHostName = portalInetAddress.getHostName() + ":" + localClusterNode.getPortalPort();
        for (String localClusterConnectionConfiguration : localClusterConnectionConfigurations = this.crossClusterReplicationConfigurationWrapper.getCCRLocalClusterConnectionConfigurations()) {
            List localClusterConnectionConfigurationParts = StringUtil.split((String)localClusterConnectionConfiguration);
            String hostName = (String)localClusterConnectionConfigurationParts.get(0);
            if (!hostName.equals(localClusterNodeHostName)) continue;
            return (String)localClusterConnectionConfigurationParts.get(1);
        }
        return null;
    }

    public List<String> getLocalClusterConnectionIds() {
        String[] localClusterConnectionConfigurations;
        ArrayList<String> connectionIds = new ArrayList<String>();
        for (String localClusterConnectionConfiguration : localClusterConnectionConfigurations = this.crossClusterReplicationConfigurationWrapper.getCCRLocalClusterConnectionConfigurations()) {
            List localClusterConnectionConfigurationParts = StringUtil.split((String)localClusterConnectionConfiguration);
            connectionIds.add((String)localClusterConnectionConfigurationParts.get(1));
        }
        return connectionIds;
    }

    public RESTClientLoggerLevel getRESTClientLoggerLevel() {
        return this._elasticsearchConfiguration.restClientLoggerLevel();
    }

    public boolean isCrossClusterReplicationEnabled() {
        if (this.crossClusterReplicationConfigurationWrapper == null) {
            return false;
        }
        if (ArrayUtil.isEmpty((Object[])this.crossClusterReplicationConfigurationWrapper.getCCRLocalClusterConnectionConfigurations())) {
            return false;
        }
        return this.crossClusterReplicationConfigurationWrapper.isCCREnabled();
    }

    public synchronized void registerCompanyId(long companyId) {
        this._companyIds.put(companyId, companyId);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, target="(operation.mode=EMBEDDED)", unbind="unsetElasticsearchConnection")
    public void setEmbeddedElasticsearchConnection(ElasticsearchConnection elasticsearchConnection) {
        this._elasticsearchConnections.put("EMBEDDED", elasticsearchConnection);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, target="(operation.mode=REMOTE)", unbind="unsetElasticsearchConnection")
    public void setRemoteElasticsearchConnection(ElasticsearchConnection elasticsearchConnection) {
        this._elasticsearchConnections.put("REMOTE", elasticsearchConnection);
    }

    public synchronized void unregisterCompanyId(long companyId) {
        this._companyIds.remove(companyId);
    }

    public void unsetElasticsearchConnection(ElasticsearchConnection elasticsearchConnection) {
        this._elasticsearchConnections.remove(elasticsearchConnection.getConnectionId());
        elasticsearchConnection.close();
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        this.activate(this.translate(this._elasticsearchConfiguration.operationMode()));
    }

    protected void addCCRElasticsearchConnection(CCRElasticsearchConnection ccrElasticsearchConnection) {
        if (!Validator.isBlank((String)ccrElasticsearchConnection.getConnectionId())) {
            this._ccrElasticsearchConnections.put(ccrElasticsearchConnection.getConnectionId(), ccrElasticsearchConnection);
        }
    }

    @Modified
    protected synchronized void modified(Map<String, Object> properties) {
        this._elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        this.modify(this.translate(this._elasticsearchConfiguration.operationMode()));
    }

    protected synchronized void modify(OperationMode operationMode) {
        if (Objects.equals((Object)operationMode, (Object)this._operationMode)) {
            return;
        }
        this.validate(operationMode);
        ElasticsearchConnection newElasticsearchConnection = this._elasticsearchConnections.get(operationMode.toString());
        newElasticsearchConnection.connect();
        if (this._operationMode != null) {
            ElasticsearchConnection oldElasticsearchConnection = this._elasticsearchConnections.get(this._operationMode.toString());
            try {
                oldElasticsearchConnection.close();
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to close " + oldElasticsearchConnection), (Throwable)exception);
            }
        }
        this._operationMode = operationMode;
        for (Long companyId : this._companyIds.values()) {
            try {
                this.indexFactory.createIndices(this.getAdminClient(), companyId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to reinitialize index for company " + companyId), (Throwable)exception);
            }
        }
    }

    protected void removeCCRElasticsearchConnection(CCRElasticsearchConnection ccrElasticsearchConnection) {
        this._ccrElasticsearchConnections.remove(ccrElasticsearchConnection.getConnectionId());
    }

    @Reference(unbind="-")
    protected void setClusterExecutor(ClusterExecutor clusterExecutor) {
        this._clusterExecutor = clusterExecutor;
    }

    protected OperationMode translate(com.liferay.portal.search.elasticsearch6.configuration.OperationMode operationMode) {
        return OperationMode.valueOf(operationMode.name());
    }

    protected void validate(OperationMode operationMode) {
        if (!this._elasticsearchConnections.containsKey(operationMode.toString())) {
            throw new MissingOperationModeException(operationMode);
        }
    }
}

