/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.connection;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.configuration.ElasticsearchConnectionConfigurationWrapper;
import com.liferay.portal.search.elasticsearch6.internal.connection.BaseElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.connection.OperationMode;
import com.liferay.portal.search.elasticsearch6.internal.settings.SettingsBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch.cross.cluster.replication.internal.configuration.ElasticsearchConnectionConfiguration"}, immediate=true, property={"operation.mode=CCR"}, service={CCRElasticsearchConnection.class})
public class CCRElasticsearchConnection
extends BaseElasticsearchConnection {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected volatile ElasticsearchConnectionConfigurationWrapper elasticsearchConnectionConfigurationWrapper;
    @Reference
    protected volatile ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected Props props;
    private static final Log _log = LogFactoryUtil.getLog(CCRElasticsearchConnection.class);
    private String _connectionId;

    @Override
    public String getConnectionId() {
        return this._connectionId;
    }

    @Override
    public OperationMode getOperationMode() {
        return OperationMode.REMOTE;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._connectionId = (String)properties.get("connectionId");
        if (!Validator.isBlank((String)this._connectionId)) {
            this.reconnect();
            this.elasticsearchConnectionManager.addCCRElasticsearchConnection(this);
        }
    }

    protected void addTransportAddress(TransportClient transportClient, String transportAddress) throws UnknownHostException {
        String[] transportAddressParts = StringUtil.split((String)transportAddress, (String)":");
        String host = transportAddressParts[0];
        int port = GetterUtil.getInteger((String)transportAddressParts[1]);
        InetAddress inetAddress = InetAddressUtil.getInetAddressByName((String)host);
        transportClient.addTransportAddress(new TransportAddress(inetAddress, port));
    }

    protected void configureAuthentication(SettingsBuilder settingsBuilder) {
        String username = this.elasticsearchConnectionConfigurationWrapper.getUsername(this._connectionId);
        String password = this.elasticsearchConnectionConfigurationWrapper.getPassword(this._connectionId);
        String user = username + ":" + password;
        settingsBuilder.put("xpack.security.user", user);
    }

    protected void configurePEMPaths(SettingsBuilder settingsBuilder) {
        settingsBuilder.put("xpack.security.transport.ssl.certificate", this.elasticsearchConnectionConfigurationWrapper.getSslCertificatePath(this._connectionId));
        settingsBuilder.putList("xpack.security.transport.ssl.certificate_authorities", this.elasticsearchConnectionConfigurationWrapper.getSslCertificateAuthoritiesPaths(this._connectionId));
        settingsBuilder.put("xpack.security.transport.ssl.key", this.elasticsearchConnectionConfigurationWrapper.getSslKeyPath(this._connectionId));
    }

    protected void configurePKCSPaths(SettingsBuilder settingsBuilder) {
        settingsBuilder.put("xpack.security.transport.ssl.keystore.password", this.elasticsearchConnectionConfigurationWrapper.getSslKeystorePassword(this._connectionId));
        settingsBuilder.put("xpack.security.transport.ssl.keystore.path", this.elasticsearchConnectionConfigurationWrapper.getSslKeystorePath(this._connectionId));
        settingsBuilder.put("xpack.security.transport.ssl.truststore.password", this.elasticsearchConnectionConfigurationWrapper.getSslTruststorePassword(this._connectionId));
        settingsBuilder.put("xpack.security.transport.ssl.truststore.path", this.elasticsearchConnectionConfigurationWrapper.getSslTruststorePath(this._connectionId));
    }

    protected void configureSSL(SettingsBuilder settingsBuilder) {
        settingsBuilder.put("xpack.security.transport.ssl.enabled", "true");
        settingsBuilder.put("xpack.security.transport.ssl.verification_mode", StringUtil.toLowerCase((String)this.elasticsearchConnectionConfigurationWrapper.getTransportSSLVerificationMode(this._connectionId)));
        String certificateFormat = this.elasticsearchConnectionConfigurationWrapper.getCertificateFormat(this._connectionId);
        if (certificateFormat.equals("PKCS#12")) {
            this.configurePKCSPaths(settingsBuilder);
        } else {
            this.configurePEMPaths(settingsBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Client createClient() {
        Set transportAddresses = SetUtil.fromArray((Object[])this.elasticsearchConnectionConfigurationWrapper.getTransportAddresses(this._connectionId));
        if (transportAddresses.isEmpty()) {
            throw new IllegalStateException("There must be at least one transport address");
        }
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        Class<?> clazz = this.getClass();
        thread.setContextClassLoader(clazz.getClassLoader());
        try {
            TransportClient transportClient = this.createTransportClient();
            for (String transportAddress : transportAddresses) {
                try {
                    this.addTransportAddress(transportClient, transportAddress);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to add transport address " + transportAddress), (Throwable)exception);
                }
            }
            TransportClient transportClient2 = transportClient;
            return transportClient2;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    protected TransportClient createTransportClient() {
        if (this.elasticsearchConnectionConfigurationWrapper.isAuthenticationEnabled(this._connectionId)) {
            this.configureAuthentication(this.settingsBuilder);
        }
        if (this.elasticsearchConnectionConfigurationWrapper.isTransportSSLEnabled(this._connectionId)) {
            this.configureSSL(this.settingsBuilder);
        }
        Settings settings = this.settingsBuilder.build();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Settings: " + settings.toString()));
        }
        if (this.elasticsearchConnectionConfigurationWrapper.isAuthenticationEnabled(this._connectionId) || this.elasticsearchConnectionConfigurationWrapper.isTransportSSLEnabled(this._connectionId)) {
            return new PreBuiltXPackTransportClient(settings, new Class[0]);
        }
        return new PreBuiltTransportClient(settings, new Class[0]);
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties) {
        this.close();
        this.elasticsearchConnectionManager.removeCCRElasticsearchConnection(this);
    }

    @Override
    protected void loadRequiredDefaultConfigurations() {
        this.settingsBuilder.put("client.transport.ignore_cluster_name", this.elasticsearchConnectionConfigurationWrapper.isClientTransportIgnoreClusterName(this._connectionId));
        this.settingsBuilder.put("client.transport.nodes_sampler_interval", this.elasticsearchConnectionConfigurationWrapper.getClientTransportNodesSamplerInterval(this._connectionId));
        this.settingsBuilder.put("client.transport.ping_timeout", this.elasticsearchConnectionConfigurationWrapper.getClientTransportPingTimeout(this._connectionId));
        this.settingsBuilder.put("client.transport.sniff", this.elasticsearchConnectionConfigurationWrapper.isClientTransportSniff(this._connectionId));
        this.settingsBuilder.put("cluster.name", this.elasticsearchConnectionConfigurationWrapper.getClusterName(this._connectionId));
        this.settingsBuilder.put("request.headers.X-Found-Cluster", this.elasticsearchConnectionConfigurationWrapper.getClusterName(this._connectionId));
    }

    protected void reconnect() {
        if (this.isConnected()) {
            this.close();
        }
        if (!this.isConnected()) {
            this.connect();
        }
    }
}

