/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.connection;

import com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexFactory;
import com.liferay.portal.search.elasticsearch6.internal.settings.SettingsBuilder;
import com.liferay.portal.search.elasticsearch6.internal.util.ResourceUtil;
import com.liferay.portal.search.elasticsearch6.settings.ClientSettingsHelper;
import com.liferay.portal.search.elasticsearch6.settings.SettingsContributor;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;

public abstract class BaseElasticsearchConnection
implements ElasticsearchConnection {
    protected volatile ElasticsearchConfiguration elasticsearchConfiguration;
    protected SettingsBuilder settingsBuilder = new SettingsBuilder(Settings.builder());
    private Client _client;
    private IndexFactory _indexFactory;
    private final Set<SettingsContributor> _settingsContributors = new ConcurrentSkipListSet<SettingsContributor>();

    @Override
    public void close() {
        if (this._client == null) {
            return;
        }
        this._client.close();
        this._client = null;
    }

    @Override
    public void connect() {
        this.settingsBuilder = new SettingsBuilder(Settings.builder());
        this.loadOptionalDefaultConfigurations();
        this.loadAdditionalConfigurations();
        this.loadRequiredDefaultConfigurations();
        this.loadSettingsContributors();
        this._client = this.createClient();
    }

    @Override
    public Client getClient() {
        return this._client;
    }

    @Override
    public ClusterHealthResponse getClusterHealthResponse(long timeout) {
        Client client = this.getClient();
        AdminClient adminClient = client.admin();
        ClusterAdminClient clusterAdminClient = adminClient.cluster();
        ClusterHealthRequestBuilder clusterHealthRequestBuilder = clusterAdminClient.prepareHealth(new String[0]);
        clusterHealthRequestBuilder.setTimeout(TimeValue.timeValueMillis((long)timeout));
        clusterHealthRequestBuilder.setWaitForYellowStatus();
        ActionFuture future = clusterHealthRequestBuilder.execute();
        try {
            return (ClusterHealthResponse)future.get();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public boolean isConnected() {
        return this._client != null;
    }

    public void setIndexFactory(IndexFactory indexFactory) {
        this._indexFactory = indexFactory;
    }

    protected void addSettingsContributor(SettingsContributor settingsContributor) {
        this._settingsContributors.add(settingsContributor);
    }

    protected abstract Client createClient();

    protected IndexFactory getIndexFactory() {
        return this._indexFactory;
    }

    protected void loadAdditionalConfigurations() {
        if (this.elasticsearchConfiguration != null) {
            this.settingsBuilder.loadFromSource(this.elasticsearchConfiguration.additionalConfigurations());
        }
    }

    protected void loadOptionalDefaultConfigurations() {
        String defaultConfigurations = ResourceUtil.getResourceAsString(this.getClass(), "/META-INF/elasticsearch-optional-defaults.yml");
        this.settingsBuilder.loadFromSource(defaultConfigurations);
    }

    protected abstract void loadRequiredDefaultConfigurations();

    protected void loadSettingsContributors() {
        ClientSettingsHelper clientSettingsHelper = new ClientSettingsHelper(){

            public void put(String setting, String value) {
                BaseElasticsearchConnection.this.settingsBuilder.put(setting, value);
            }

            public void putArray(String setting, String ... values) {
                BaseElasticsearchConnection.this.settingsBuilder.putList(setting, values);
            }
        };
        for (SettingsContributor settingsContributor : this._settingsContributors) {
            settingsContributor.populate(clientSettingsHelper);
        }
    }

    protected void removeSettingsContributor(SettingsContributor settingsContributor) {
        this._settingsContributors.remove(settingsContributor);
    }
}

