/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.aggregation.bucket;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.aggregation.bucket.CollectionMode;
import com.liferay.portal.search.aggregation.bucket.TermsAggregation;
import com.liferay.portal.search.elasticsearch6.internal.aggregation.bucket.IncludeExcludeTranslator;
import com.liferay.portal.search.elasticsearch6.internal.aggregation.bucket.OrderTranslator;
import com.liferay.portal.search.elasticsearch6.internal.aggregation.bucket.TermsAggregationTranslator;
import java.util.List;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={TermsAggregationTranslator.class})
public class TermsAggregationTranslatorImpl
implements TermsAggregationTranslator {
    private final IncludeExcludeTranslator _includeExcludeTranslator = new IncludeExcludeTranslator();
    private final OrderTranslator _orderTranslator = new OrderTranslator();

    @Override
    public TermsAggregationBuilder translate(TermsAggregation termsAggregation) {
        TermsAggregationBuilder termsAggregationBuilder = AggregationBuilders.terms((String)termsAggregation.getName());
        if (termsAggregation.getCollectionMode() != null) {
            CollectionMode collectionMode = termsAggregation.getCollectionMode();
            if (collectionMode == CollectionMode.BREADTH_FIRST) {
                termsAggregationBuilder.collectMode(Aggregator.SubAggCollectionMode.BREADTH_FIRST);
            } else if (collectionMode == CollectionMode.DEPTH_FIRST) {
                termsAggregationBuilder.collectMode(Aggregator.SubAggCollectionMode.DEPTH_FIRST);
            }
        }
        if (termsAggregation.getExecutionHint() != null) {
            termsAggregationBuilder.executionHint(termsAggregation.getExecutionHint());
        }
        if (termsAggregation.getIncludeExcludeClause() != null) {
            termsAggregationBuilder.includeExclude(this._includeExcludeTranslator.translate(termsAggregation.getIncludeExcludeClause()));
        }
        if (termsAggregation.getMinDocCount() != null) {
            termsAggregationBuilder.minDocCount((long)termsAggregation.getMinDocCount().intValue());
        }
        if (!ListUtil.isEmpty((List)termsAggregation.getOrders())) {
            List<BucketOrder> bucketOrders = this._orderTranslator.translate(termsAggregation.getOrders());
            termsAggregationBuilder.order(bucketOrders);
        }
        if (termsAggregation.getShardMinDocCount() != null) {
            termsAggregationBuilder.shardMinDocCount((long)termsAggregation.getShardMinDocCount().intValue());
        }
        if (termsAggregation.getShardSize() != null) {
            termsAggregationBuilder.shardSize(termsAggregation.getShardSize().intValue());
        }
        if (termsAggregation.getShowTermDocCountError() != null) {
            termsAggregationBuilder.showTermDocCountError(termsAggregation.getShowTermDocCountError().booleanValue());
        }
        if (termsAggregation.getSize() != null) {
            termsAggregationBuilder.size(termsAggregation.getSize().intValue());
        }
        return termsAggregationBuilder;
    }
}

