/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.aggregation.bucket;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.aggregation.bucket.DateHistogramAggregation;
import com.liferay.portal.search.elasticsearch6.internal.aggregation.bucket.DateHistogramAggregationTranslator;
import com.liferay.portal.search.elasticsearch6.internal.aggregation.bucket.OrderTranslator;
import java.util.List;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.osgi.service.component.annotations.Component;

@Component(service={DateHistogramAggregationTranslator.class})
public class DateHistogramAggregationTranslatorImpl
implements DateHistogramAggregationTranslator {
    private final OrderTranslator _orderTranslator = new OrderTranslator();

    @Override
    public DateHistogramAggregationBuilder translate(DateHistogramAggregation dateHistogramAggregation) {
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder = AggregationBuilders.dateHistogram((String)dateHistogramAggregation.getName());
        if (!ListUtil.isEmpty((List)dateHistogramAggregation.getOrders())) {
            List<BucketOrder> bucketOrders = this._orderTranslator.translate(dateHistogramAggregation.getOrders());
            dateHistogramAggregationBuilder.order(bucketOrders);
        }
        if (dateHistogramAggregation.getMaxBound() != null && dateHistogramAggregation.getMinBound() != null) {
            ExtendedBounds extendedBounds = new ExtendedBounds(dateHistogramAggregation.getMinBound(), dateHistogramAggregation.getMaxBound());
            dateHistogramAggregationBuilder.extendedBounds(extendedBounds);
        }
        if (dateHistogramAggregation.getMinDocCount() != null) {
            dateHistogramAggregationBuilder.minDocCount(dateHistogramAggregation.getMinDocCount().longValue());
        }
        if (dateHistogramAggregation.getDateHistogramInterval() != null) {
            dateHistogramAggregationBuilder.dateHistogramInterval(new DateHistogramInterval(dateHistogramAggregation.getDateHistogramInterval()));
        }
        if (dateHistogramAggregation.getInterval() != null) {
            dateHistogramAggregationBuilder.interval(dateHistogramAggregation.getInterval().longValue());
        }
        if (dateHistogramAggregation.getOffset() != null) {
            dateHistogramAggregationBuilder.offset(dateHistogramAggregation.getOffset().longValue());
        }
        return dateHistogramAggregationBuilder;
    }
}

