/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch6.internal.SearchHitDocumentTranslator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={SearchHitDocumentTranslator.class})
public class SearchHitDocumentTranslatorImpl
implements SearchHitDocumentTranslator {
    @Override
    public Document translate(SearchHit searchHit) {
        DocumentImpl document = new DocumentImpl();
        Map documentFields = searchHit.getFields();
        for (String documentFieldName : documentFields.keySet()) {
            this.addField((Document)document, documentFieldName, documentFields);
        }
        return document;
    }

    protected void addField(Document document, String fieldName, Map<String, DocumentField> documentFields) {
        Field field = this.getField(fieldName, documentFields);
        if (field != null) {
            document.add(field);
        }
    }

    protected Field getField(String fieldName, Map<String, DocumentField> documentFields) {
        String geopointIndicatorSuffix = ".geopoint";
        if (fieldName.endsWith(geopointIndicatorSuffix)) {
            return null;
        }
        DocumentField documentField = documentFields.get(fieldName);
        if (documentFields.containsKey(fieldName.concat(geopointIndicatorSuffix))) {
            return this.translateGeoPoint(documentField);
        }
        return this.translate(documentField);
    }

    protected Field translate(DocumentField documentField) {
        String name = documentField.getName();
        List values = documentField.getValues();
        return new Field(name, ArrayUtil.toStringArray((Object[])values.toArray(new Object[0])));
    }

    protected Field translateGeoPoint(DocumentField documentField) {
        Field field = new Field(documentField.getName());
        String[] values = StringUtil.split((String)((String)documentField.getValue()));
        field.setGeoLocationPoint(new GeoLocationPoint(Double.valueOf(values[0]).doubleValue(), Double.valueOf(values[1]).doubleValue()));
        return field;
    }
}

