/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseSearchEngine;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexFactory;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.cluster.ClusterHealthStatus;
import com.liferay.portal.search.engine.adapter.cluster.ClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterResponse;
import com.liferay.portal.search.engine.adapter.index.CloseIndexRequest;
import com.liferay.portal.search.engine.adapter.index.CloseIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRepositoryRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.CreateSnapshotResponse;
import com.liferay.portal.search.engine.adapter.snapshot.DeleteSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotRepositoriesRequest;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotRepositoriesResponse;
import com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotDetails;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotRequest;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotState;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.id=SYSTEM_ENGINE", "search.engine.impl=Elasticsearch"}, service={ElasticsearchSearchEngine.class, SearchEngine.class})
public class ElasticsearchSearchEngine
extends BaseSearchEngine {
    private static final String _BACKUP_REPOSITORY_NAME = "liferay_backup";
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchSearchEngine.class);
    private ElasticsearchConnectionManager _elasticsearchConnectionManager;
    private IndexFactory _indexFactory;
    private IndexNameBuilder _indexNameBuilder;
    private SearchEngineAdapter _searchEngineAdapter;

    public synchronized String backup(long companyId, String backupName) throws SearchException {
        backupName = StringUtil.toLowerCase((String)backupName);
        this.validateBackupName(backupName);
        this.createBackupRepository();
        CreateSnapshotRequest createSnapshotRequest = new CreateSnapshotRequest(_BACKUP_REPOSITORY_NAME, backupName);
        createSnapshotRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId)});
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this._searchEngineAdapter.execute((SnapshotRequest)createSnapshotRequest);
        SnapshotDetails snapshotDetails = createSnapshotResponse.getSnapshotDetails();
        SnapshotState snapshotState = snapshotDetails.getSnapshotState();
        if (snapshotState.equals((Object)SnapshotState.FAILED)) {
            throw new IllegalStateException("Unable to complete snapshot");
        }
        return backupName;
    }

    public void initialize(long companyId) {
        super.initialize(companyId);
        this.waitForYellowStatus();
        Client client = this._elasticsearchConnectionManager.getClient();
        this._indexFactory.createIndices(client.admin(), companyId);
        this._elasticsearchConnectionManager.registerCompanyId(companyId);
        this.waitForYellowStatus();
    }

    public synchronized void removeBackup(long companyId, String backupName) {
        if (!this.hasBackupRepository()) {
            return;
        }
        DeleteSnapshotRequest deleteSnapshotRequest = new DeleteSnapshotRequest(_BACKUP_REPOSITORY_NAME, backupName);
        this._searchEngineAdapter.execute((SnapshotRequest)deleteSnapshotRequest);
    }

    public void removeCompany(long companyId) {
        block2: {
            super.removeCompany(companyId);
            try {
                this._indexFactory.deleteIndices(this._elasticsearchConnectionManager.getAdminClient(), companyId);
                this._elasticsearchConnectionManager.unregisterCompanyId(companyId);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to delete index for " + companyId), (Throwable)exception);
            }
        }
    }

    public synchronized void restore(long companyId, String backupName) throws SearchException {
        backupName = StringUtil.toLowerCase((String)backupName);
        this.validateBackupName(backupName);
        CloseIndexRequest closeIndexRequest = new CloseIndexRequest(new String[]{this._indexNameBuilder.getIndexName(companyId)});
        CloseIndexResponse closeIndexResponse = (CloseIndexResponse)this._searchEngineAdapter.execute((IndexRequest)closeIndexRequest);
        if (!closeIndexResponse.isAcknowledged()) {
            throw new SystemException("Error closing index: " + this._indexNameBuilder.getIndexName(companyId));
        }
        RestoreSnapshotRequest restoreSnapshotRequest = new RestoreSnapshotRequest(_BACKUP_REPOSITORY_NAME, backupName);
        restoreSnapshotRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId)});
        this._searchEngineAdapter.execute((SnapshotRequest)restoreSnapshotRequest);
        this.waitForYellowStatus();
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    public void setIndexSearcher(IndexSearcher indexSearcher) {
        super.setIndexSearcher(indexSearcher);
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    public void setIndexWriter(IndexWriter indexWriter) {
        super.setIndexWriter(indexWriter);
    }

    public void unsetElasticsearchConnectionManager(ElasticsearchConnectionManager elasticsearchConnectionManager) {
        this._elasticsearchConnectionManager = null;
    }

    public void unsetIndexFactory(IndexFactory indexFactory) {
        this._indexFactory = null;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.setVendor(MapUtil.getString(properties, (String)"search.engine.impl"));
    }

    protected void createBackupRepository() {
        if (this.hasBackupRepository()) {
            return;
        }
        CreateSnapshotRepositoryRequest createSnapshotRepositoryRequest = new CreateSnapshotRepositoryRequest(_BACKUP_REPOSITORY_NAME, "es_backup");
        this._searchEngineAdapter.execute((SnapshotRequest)createSnapshotRepositoryRequest);
    }

    protected boolean hasBackupRepository() {
        try {
            GetSnapshotRepositoriesRequest getSnapshotRepositoriesRequest = new GetSnapshotRepositoriesRequest(new String[]{_BACKUP_REPOSITORY_NAME});
            GetSnapshotRepositoriesResponse getSnapshotRepositoriesResponse = (GetSnapshotRepositoriesResponse)this._searchEngineAdapter.execute((SnapshotRequest)getSnapshotRepositoriesRequest);
            List snapshotRepositoryDetailsList = getSnapshotRepositoriesResponse.getSnapshotRepositoryDetails();
            if (snapshotRepositoryDetailsList.isEmpty()) {
                return false;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        return true;
    }

    @Reference
    protected void setElasticsearchConnectionManager(ElasticsearchConnectionManager elasticsearchConnectionManager) {
        this._elasticsearchConnectionManager = elasticsearchConnectionManager;
    }

    @Reference
    protected void setIndexFactory(IndexFactory indexFactory) {
        this._indexFactory = indexFactory;
    }

    @Reference(unbind="-")
    protected void setIndexNameBuilder(IndexNameBuilder indexNameBuilder) {
        this._indexNameBuilder = indexNameBuilder;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setSearchEngineAdapter(SearchEngineAdapter searchEngineAdapter) {
        this._searchEngineAdapter = searchEngineAdapter;
    }

    protected void validateBackupName(String backupName) throws SearchException {
        if (Validator.isNull((String)backupName)) {
            throw new SearchException("Backup name must not be an empty string");
        }
        if (StringUtil.contains((String)backupName, (String)",")) {
            throw new SearchException("Backup name must not contain comma");
        }
        if (StringUtil.startsWith((String)backupName, (String)"-")) {
            throw new SearchException("Backup name must not start with dash");
        }
        if (StringUtil.contains((String)backupName, (String)"#")) {
            throw new SearchException("Backup name must not contain pounds");
        }
        if (StringUtil.contains((String)backupName, (String)" ")) {
            throw new SearchException("Backup name must not contain spaces");
        }
        if (StringUtil.contains((String)backupName, (String)"\t")) {
            throw new SearchException("Backup name must not contain tabs");
        }
        for (char c : backupName.toCharArray()) {
            if (!Strings.INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            throw new SearchException("Backup name must not contain invalid file name characters");
        }
    }

    protected void waitForYellowStatus() {
        long timeout = 30000L;
        if (PortalRunMode.isTestMode()) {
            timeout = 3600000L;
        }
        HealthClusterRequest healthClusterRequest = new HealthClusterRequest();
        healthClusterRequest.setTimeout(timeout);
        healthClusterRequest.setWaitForClusterHealthStatus(ClusterHealthStatus.YELLOW);
        HealthClusterResponse healthClusterResponse = (HealthClusterResponse)this._searchEngineAdapter.execute((ClusterRequest)healthClusterRequest);
        if (healthClusterResponse.getClusterHealthStatus() == ClusterHealthStatus.RED) {
            throw new IllegalStateException("Unable to initialize Elasticsearch cluster: " + healthClusterResponse);
        }
    }
}

