/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
package org.elasticsearch.xpack.core.security.action.user;

import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;

public class AuthenticateRequestBuilder
        extends ActionRequestBuilder<AuthenticateRequest, AuthenticateResponse, AuthenticateRequestBuilder> {

    public AuthenticateRequestBuilder(ElasticsearchClient client) {
        this(client, AuthenticateAction.INSTANCE);
    }

    public AuthenticateRequestBuilder(ElasticsearchClient client, AuthenticateAction action) {
        super(client, action, new AuthenticateRequest());
    }

    public AuthenticateRequestBuilder username(String username) {
        request.username(username);
        return this;
    }
}
