/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot.GetSnapshotsRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot.SnapshotInfoConverter;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotsRequest;
import com.liferay.portal.search.engine.adapter.snapshot.GetSnapshotsResponse;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotDetails;
import java.util.List;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetSnapshotsRequestExecutor.class})
public class GetSnapshotsRequestExecutorImpl
implements GetSnapshotsRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public GetSnapshotsResponse execute(GetSnapshotsRequest getSnapshotsRequest) {
        GetSnapshotsRequestBuilder getSnapshotsRequestBuilder = this.createGetSnapshotsRequest(getSnapshotsRequest);
        org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse elasticsearchGetSnapshotsResponse = (org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse)getSnapshotsRequestBuilder.get();
        GetSnapshotsResponse getSnapshotsResponse = new GetSnapshotsResponse();
        List snapshotInfos = elasticsearchGetSnapshotsResponse.getSnapshots();
        snapshotInfos.forEach(snapshotInfo -> {
            SnapshotDetails snapshotDetails = SnapshotInfoConverter.convert(snapshotInfo);
            getSnapshotsResponse.addSnapshotInfo(snapshotDetails);
        });
        return getSnapshotsResponse;
    }

    protected GetSnapshotsRequestBuilder createGetSnapshotsRequest(GetSnapshotsRequest getSnapshotsRequest) {
        GetSnapshotsRequestBuilder getSnapshotsRequestBuilder = GetSnapshotsAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient());
        getSnapshotsRequestBuilder.setIgnoreUnavailable(getSnapshotsRequest.isIgnoreUnavailable());
        getSnapshotsRequestBuilder.setRepository(getSnapshotsRequest.getRepositoryName());
        getSnapshotsRequestBuilder.setSnapshots(getSnapshotsRequest.getSnapshotNames());
        getSnapshotsRequestBuilder.setVerbose(getSnapshotsRequest.isVerbose());
        return getSnapshotsRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

