/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.MultisearchSearchRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.engine.adapter.search.MultisearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.MultisearchSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.search.MultiSearchAction;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MultisearchSearchRequestExecutor.class})
public class MultisearchSearchRequestExecutorImpl
implements MultisearchSearchRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(MultisearchSearchRequestExecutorImpl.class);
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private SearchSearchRequestAssembler _searchSearchRequestAssembler;
    private SearchSearchResponseAssembler _searchSearchResponseAssembler;

    @Override
    public MultisearchSearchResponse execute(MultisearchSearchRequest multisearchSearchRequest) {
        Client client = this._elasticsearchClientResolver.getClient();
        MultiSearchRequestBuilder multiSearchRequestBuilder = MultiSearchAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        List searchSearchRequests = multisearchSearchRequest.getSearchSearchRequests();
        ArrayList searchRequestHolders = new ArrayList(searchSearchRequests.size());
        searchSearchRequests.forEach(searchSearchRequest -> {
            SearchRequestBuilder searchRequestBuilder = SearchAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
            this._searchSearchRequestAssembler.assemble(searchRequestBuilder, (SearchSearchRequest)searchSearchRequest);
            SearchRequestHolder searchRequestHolder = new SearchRequestHolder((SearchSearchRequest)searchSearchRequest, searchRequestBuilder);
            searchRequestHolders.add(searchRequestHolder);
            multiSearchRequestBuilder.add(searchRequestBuilder);
        });
        MultiSearchResponse multiSearchResponse = (MultiSearchResponse)multiSearchRequestBuilder.get();
        Iterator multiSearchResponseItems = multiSearchResponse.iterator();
        MultisearchSearchResponse multisearchSearchResponse = new MultisearchSearchResponse();
        int counter = 0;
        while (multiSearchResponseItems.hasNext()) {
            MultiSearchResponse.Item multiSearchResponseItem = (MultiSearchResponse.Item)multiSearchResponseItems.next();
            SearchResponse searchResponse = multiSearchResponseItem.getResponse();
            SearchSearchResponse searchSearchResponse = new SearchSearchResponse();
            SearchRequestHolder searchRequestHolder = (SearchRequestHolder)searchRequestHolders.get(counter);
            SearchSearchRequest searchSearchRequest2 = searchRequestHolder.getSearchSearchRequest();
            this._searchSearchResponseAssembler.assemble(searchRequestHolder.getSearchRequestBuilder(), searchResponse, searchSearchRequest2, searchSearchResponse);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"The search engine processed ", searchSearchResponse.getSearchRequestString(), " in ", searchSearchResponse.getExecutionTime() + " ms"}));
            }
            if (searchSearchRequest2.isIncludeResponseString()) {
                searchSearchResponse.setSearchResponseString(searchResponse.toString());
            }
            ++counter;
        }
        return multisearchSearchResponse;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setSearchSearchRequestAssembler(SearchSearchRequestAssembler searchSearchRequestAssembler) {
        this._searchSearchRequestAssembler = searchSearchRequestAssembler;
    }

    @Reference(unbind="-")
    protected void setSearchSearchResponseAssembler(SearchSearchResponseAssembler searchSearchResponseAssembler) {
        this._searchSearchResponseAssembler = searchSearchResponseAssembler;
    }

    private class SearchRequestHolder {
        private final SearchRequestBuilder _searchRequestBuilder;
        private final SearchSearchRequest _searchSearchRequest;

        public SearchRequestHolder(SearchSearchRequest searchSearchRequest, SearchRequestBuilder searchRequestBuilder) {
            this._searchSearchRequest = searchSearchRequest;
            this._searchRequestBuilder = searchRequestBuilder;
        }

        public SearchRequestBuilder getSearchRequestBuilder() {
            return this._searchRequestBuilder;
        }

        public SearchSearchRequest getSearchSearchRequest() {
            return this._searchSearchRequest;
        }
    }
}

