/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterTranslator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.aggregation.AggregationTranslator;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationTranslator;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetTranslator;
import com.liferay.portal.search.elasticsearch6.internal.filter.FilterToQueryBuilderTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.QueryToQueryBuilderTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.CommonSearchRequestBuilderAssembler;
import com.liferay.portal.search.elasticsearch6.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.filter.ComplexQueryBuilderFactory;
import com.liferay.portal.search.filter.ComplexQueryPart;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.stats.StatsRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.rescore.QueryRescorerBuilder;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommonSearchRequestBuilderAssembler.class})
public class CommonSearchRequestBuilderAssemblerImpl
implements CommonSearchRequestBuilderAssembler {
    private AggregationTranslator<AggregationBuilder> _aggregationTranslator;
    private ComplexQueryBuilderFactory _complexQueryBuilderFactory;
    private FacetTranslator _facetTranslator;
    private FilterTranslator<QueryBuilder> _filterToQueryBuilderTranslator;
    private com.liferay.portal.search.elasticsearch6.internal.legacy.query.QueryToQueryBuilderTranslator _legacyQueryToQueryBuilderTranslator;
    private PipelineAggregationTranslator<PipelineAggregationBuilder> _pipelineAggregationTranslator;
    private QueryToQueryBuilderTranslator _queryToQueryBuilderTranslator;
    private StatsTranslator _statsTranslator;

    @Override
    public void assemble(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        this.setAggregations(searchRequestBuilder, baseSearchRequest);
        this.setExplain(searchRequestBuilder, baseSearchRequest);
        this.setFacets(searchRequestBuilder, baseSearchRequest);
        this.setIndexBoosts(searchRequestBuilder, baseSearchRequest);
        this.setIndices(searchRequestBuilder, baseSearchRequest);
        this.setMinScore(searchRequestBuilder, baseSearchRequest);
        this.setPipelineAggregations(searchRequestBuilder, baseSearchRequest);
        this.setPostFilter(searchRequestBuilder, baseSearchRequest);
        this.setQuery(searchRequestBuilder, baseSearchRequest);
        this.setRequestCache(searchRequestBuilder, baseSearchRequest);
        this.setRescorer(searchRequestBuilder, baseSearchRequest);
        this.setStatsRequests(searchRequestBuilder, baseSearchRequest);
        this.setTimeout(searchRequestBuilder, baseSearchRequest);
        this.setTrackTotalHits(searchRequestBuilder, baseSearchRequest);
        this.setTypes(searchRequestBuilder, baseSearchRequest);
    }

    protected QueryBuilder combine(QueryBuilder queryBuilder, List<ComplexQueryPart> complexQueryParts) {
        if (complexQueryParts.isEmpty()) {
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (queryBuilder != null) {
            boolQueryBuilder.should(queryBuilder);
        }
        com.liferay.portal.search.query.BooleanQuery booleanQuery = (com.liferay.portal.search.query.BooleanQuery)this._complexQueryBuilderFactory.builder().addParts(complexQueryParts).build();
        this.copy(booleanQuery.getFilterQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0));
        this.copy(booleanQuery.getMustNotQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).mustNot(arg_0));
        this.copy(booleanQuery.getMustQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0));
        this.copy(booleanQuery.getShouldQueryClauses(), arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).should(arg_0));
        return boolQueryBuilder;
    }

    protected QueryBuilder combine(QueryBuilder queryBuilder, QueryBuilder legacyQueryBuilder) {
        if (queryBuilder == null) {
            return legacyQueryBuilder;
        }
        if (legacyQueryBuilder == null) {
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        return boolQueryBuilder.must(queryBuilder).must(legacyQueryBuilder);
    }

    protected void copy(List<Query> clauses, Consumer<QueryBuilder> consumer) {
        clauses.stream().map(this::translateQuery).forEach(consumer);
    }

    protected QueryBuilder getQueryBuilder(BaseSearchRequest baseSearchRequest) {
        QueryBuilder queryBuilder = this.translateQuery(baseSearchRequest.getQuery());
        QueryBuilder legacyQueryBuilder = this.translateQuery(baseSearchRequest.getQuery71());
        QueryBuilder combinedQueryBuilder = this.combine(queryBuilder, legacyQueryBuilder);
        List complexQueryParts = baseSearchRequest.getComplexQueryParts();
        return this.combine(combinedQueryBuilder, complexQueryParts);
    }

    protected void setAggregations(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        Map aggregationsMap = baseSearchRequest.getAggregationsMap();
        if (MapUtil.isNotEmpty((Map)aggregationsMap)) {
            Collection aggregations = aggregationsMap.values();
            aggregations.forEach(aggregation -> {
                AggregationBuilder aggregationBuilder = (AggregationBuilder)this._aggregationTranslator.translate(aggregation);
                searchRequestBuilder.addAggregation(aggregationBuilder);
            });
        }
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setAggregationTranslator(AggregationTranslator<AggregationBuilder> aggregationTranslator) {
        this._aggregationTranslator = aggregationTranslator;
    }

    @Reference(unbind="-")
    protected void setComplexQueryBuilderFactory(ComplexQueryBuilderFactory complexQueryBuilderFactory) {
        this._complexQueryBuilderFactory = complexQueryBuilderFactory;
    }

    protected void setExplain(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getExplain() != null) {
            searchRequestBuilder.setExplain(baseSearchRequest.getExplain().booleanValue());
        }
    }

    protected void setFacets(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        this._facetTranslator.translate(searchRequestBuilder, baseSearchRequest.getQuery71(), baseSearchRequest.getFacets(), baseSearchRequest.isBasicFacetSelection());
    }

    @Reference(unbind="-")
    protected void setFacetTranslator(FacetTranslator facetTranslator) {
        this._facetTranslator = facetTranslator;
    }

    @Reference(unbind="-")
    protected void setFilterToQueryBuilderTranslator(FilterToQueryBuilderTranslator filterToQueryBuilderTranslator) {
        this._filterToQueryBuilderTranslator = filterToQueryBuilderTranslator;
    }

    protected void setIndexBoosts(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        Map indexBoosts = baseSearchRequest.getIndexBoosts();
        if (MapUtil.isNotEmpty((Map)indexBoosts)) {
            indexBoosts.forEach((arg_0, arg_1) -> ((SearchRequestBuilder)searchRequestBuilder).addIndexBoost(arg_0, arg_1));
        }
    }

    protected void setIndices(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        searchRequestBuilder.setIndices(baseSearchRequest.getIndexNames());
    }

    @Reference(unbind="-")
    protected void setLegacyQueryToQueryBuilderTranslator(com.liferay.portal.search.elasticsearch6.internal.legacy.query.QueryToQueryBuilderTranslator queryToQueryBuilderTranslator) {
        this._legacyQueryToQueryBuilderTranslator = queryToQueryBuilderTranslator;
    }

    protected void setMinScore(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getMinimumScore() != null) {
            searchRequestBuilder.setMinScore(baseSearchRequest.getMinimumScore().floatValue());
        }
    }

    protected void setPipelineAggregations(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        Map pipelineAggregationsMap = baseSearchRequest.getPipelineAggregationsMap();
        if (MapUtil.isNotEmpty((Map)pipelineAggregationsMap)) {
            Collection pipelineAggregations = pipelineAggregationsMap.values();
            pipelineAggregations.forEach(pipelineAggregation -> {
                PipelineAggregationBuilder pipelineAggregationBuilder = (PipelineAggregationBuilder)this._pipelineAggregationTranslator.translate(pipelineAggregation);
                searchRequestBuilder.addAggregation(pipelineAggregationBuilder);
            });
        }
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setPipelineAggregationTranslator(PipelineAggregationTranslator<PipelineAggregationBuilder> pipelineAggregationTranslator) {
        this._pipelineAggregationTranslator = pipelineAggregationTranslator;
    }

    protected void setPostFilter(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getPostFilterQuery() != null) {
            searchRequestBuilder.setPostFilter(this._queryToQueryBuilderTranslator.translate(baseSearchRequest.getPostFilterQuery()));
        } else if (baseSearchRequest.getPostFilter() != null) {
            searchRequestBuilder.setPostFilter((QueryBuilder)this._filterToQueryBuilderTranslator.translate(baseSearchRequest.getPostFilter(), null));
        }
    }

    protected void setQuery(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        searchRequestBuilder.setQuery(this.getQueryBuilder(baseSearchRequest));
    }

    @Reference(unbind="-")
    protected void setQueryToQueryBuilderTranslator(QueryToQueryBuilderTranslator queryToQueryBuilderTranslator) {
        this._queryToQueryBuilderTranslator = queryToQueryBuilderTranslator;
    }

    protected void setRequestCache(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getRequestCache() != null) {
            searchRequestBuilder.setRequestCache(baseSearchRequest.getRequestCache());
        }
    }

    protected void setRescorer(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        Query query = baseSearchRequest.getRescoreQuery();
        if (query == null) {
            return;
        }
        searchRequestBuilder.setRescorer((RescorerBuilder)new QueryRescorerBuilder(this._queryToQueryBuilderTranslator.translate(query)));
    }

    protected void setStatsRequests(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        List statsRequests = baseSearchRequest.getStatsRequests();
        if (!ListUtil.isEmpty((List)statsRequests)) {
            statsRequests.forEach(statsRequest -> this._statsTranslator.populateRequest(searchRequestBuilder, (StatsRequest)statsRequest));
        }
    }

    @Reference(unbind="-")
    protected void setStatsTranslator(StatsTranslator statsTranslator) {
        this._statsTranslator = statsTranslator;
    }

    protected void setTimeout(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getTimeoutInMilliseconds() != null) {
            searchRequestBuilder.setTimeout(TimeValue.timeValueMillis((long)baseSearchRequest.getTimeoutInMilliseconds()));
        }
    }

    protected void setTrackTotalHits(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getTrackTotalHits() != null) {
            searchRequestBuilder.setTrackTotalHits(baseSearchRequest.getTrackTotalHits().booleanValue());
        }
    }

    protected void setTypes(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        if (baseSearchRequest.getTypes() != null) {
            searchRequestBuilder.setTypes(baseSearchRequest.getTypes());
        }
    }

    protected QueryBuilder translateQuery(com.liferay.portal.kernel.search.Query query) {
        if (query == null) {
            return null;
        }
        QueryBuilder queryBuilder = this._legacyQueryToQueryBuilderTranslator.translate(query, null);
        if (query.getPreBooleanFilter() == null || query instanceof BooleanQuery) {
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)this._filterToQueryBuilderTranslator.translate((Filter)query.getPreBooleanFilter(), null));
        boolQueryBuilder.must(queryBuilder);
        return boolQueryBuilder;
    }

    protected QueryBuilder translateQuery(Query query) {
        if (query != null) {
            return this._queryToQueryBuilderTranslator.translate(query);
        }
        return null;
    }
}

