/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndexRequestShardFailureTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.RefreshIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndexRequestShardFailure;
import com.liferay.portal.search.engine.adapter.index.RefreshIndexRequest;
import com.liferay.portal.search.engine.adapter.index.RefreshIndexResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RefreshIndexRequestExecutor.class})
public class RefreshIndexRequestExecutorImpl
implements RefreshIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private IndexRequestShardFailureTranslator _indexRequestShardFailureTranslator;

    @Override
    public RefreshIndexResponse execute(RefreshIndexRequest refreshIndexRequest) {
        RefreshRequestBuilder refreshRequestBuilder = this.createRefreshRequestBuilder(refreshIndexRequest);
        RefreshResponse refreshResponse = (RefreshResponse)refreshRequestBuilder.get();
        RefreshIndexResponse refreshIndexResponse = new RefreshIndexResponse();
        refreshIndexResponse.setFailedShards(refreshResponse.getFailedShards());
        refreshIndexResponse.setSuccessfulShards(refreshResponse.getSuccessfulShards());
        refreshIndexResponse.setTotalShards(refreshResponse.getTotalShards());
        Object[] shardOperationFailedExceptions = refreshResponse.getShardFailures();
        if (ArrayUtil.isNotEmpty((Object[])shardOperationFailedExceptions)) {
            for (Object shardOperationFailedException : shardOperationFailedExceptions) {
                IndexRequestShardFailure indexRequestShardFailure = this._indexRequestShardFailureTranslator.translate((ShardOperationFailedException)shardOperationFailedException);
                refreshIndexResponse.addIndexRequestShardFailure(indexRequestShardFailure);
            }
        }
        return refreshIndexResponse;
    }

    protected RefreshRequestBuilder createRefreshRequestBuilder(RefreshIndexRequest refreshIndexRequest) {
        Client client = this._elasticsearchClientResolver.getClient();
        AdminClient adminClient = client.admin();
        IndicesAdminClient indicesAdminClient = adminClient.indices();
        return indicesAdminClient.prepareRefresh(refreshIndexRequest.getIndexNames());
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setIndexRequestShardFailureTranslator(IndexRequestShardFailureTranslator indexRequestShardFailureTranslator) {
        this._indexRequestShardFailureTranslator = indexRequestShardFailureTranslator;
    }
}

