/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.GetIndexIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.GetIndexIndexRequest;
import com.liferay.portal.search.engine.adapter.index.GetIndexIndexResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GetIndexIndexRequestExecutor.class})
public class GetIndexIndexRequestExecutorImpl
implements GetIndexIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public GetIndexIndexResponse execute(GetIndexIndexRequest getIndexIndexRequest) {
        GetIndexRequestBuilder getIndexRequestBuilder = this.createGetIndexRequestBuilder(getIndexIndexRequest);
        GetIndexResponse getIndexResponse = (GetIndexResponse)getIndexRequestBuilder.get();
        GetIndexIndexResponse getIndexIndexResponse = new GetIndexIndexResponse();
        getIndexIndexResponse.setIndexNames(getIndexResponse.getIndices());
        ImmutableOpenMap indicesMappings = getIndexResponse.getMappings();
        getIndexIndexResponse.setMappings(this.convertMappings((ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>>)indicesMappings));
        ImmutableOpenMap indicesSettings = getIndexResponse.getSettings();
        getIndexIndexResponse.setSettings(this.convertSettings((ImmutableOpenMap<String, Settings>)indicesSettings));
        return getIndexIndexResponse;
    }

    protected Map<String, Map<String, String>> convertMappings(ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> indicesMappings) {
        Iterator iterator = indicesMappings.iterator();
        HashMap<String, Map<String, String>> indexMappings = new HashMap<String, Map<String, String>>();
        while (iterator.hasNext()) {
            ObjectObjectCursor objectObjectCursor = (ObjectObjectCursor)iterator.next();
            ImmutableOpenMap typeMappingsData = (ImmutableOpenMap)objectObjectCursor.value;
            HashMap<Object, String> indiceTypeMappings = new HashMap<Object, String>();
            indexMappings.put((String)objectObjectCursor.key, indiceTypeMappings);
            for (ObjectObjectCursor typeMappingsObjectObjectCursor : typeMappingsData) {
                MappingMetaData mappingMetaData = (MappingMetaData)typeMappingsObjectObjectCursor.value;
                CompressedXContent mappingContent = mappingMetaData.source();
                indiceTypeMappings.put(typeMappingsObjectObjectCursor.key, mappingContent.toString());
            }
        }
        return indexMappings;
    }

    protected Map<String, String> convertSettings(ImmutableOpenMap<String, Settings> indicesSettings) {
        Iterator iterator = indicesSettings.iterator();
        HashMap<String, String> indicesSettingsMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            ObjectObjectCursor objectObjectCursor = (ObjectObjectCursor)iterator.next();
            Settings settings = (Settings)objectObjectCursor.value;
            indicesSettingsMap.put((String)objectObjectCursor.key, settings.toString());
        }
        return indicesSettingsMap;
    }

    protected GetIndexRequestBuilder createGetIndexRequestBuilder(GetIndexIndexRequest getIndexIndexRequest) {
        Client client = this._elasticsearchClientResolver.getClient();
        GetIndexRequestBuilder getIndexRequestBuilder = GetIndexAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        getIndexRequestBuilder.setIndices(getIndexIndexRequest.getIndexNames());
        return getIndexRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

