/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.CreateIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CreateIndexRequestExecutor.class})
public class CreateIndexRequestExecutorImpl
implements CreateIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public com.liferay.portal.search.engine.adapter.index.CreateIndexResponse execute(CreateIndexRequest createIndexRequest) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.createCreateIndexRequestBuilder(createIndexRequest);
        CreateIndexResponse elasticsearchCreateIndexResponse = (CreateIndexResponse)createIndexRequestBuilder.get();
        return new com.liferay.portal.search.engine.adapter.index.CreateIndexResponse(elasticsearchCreateIndexResponse.isAcknowledged());
    }

    protected CreateIndexRequestBuilder createCreateIndexRequestBuilder(CreateIndexRequest createIndexRequest) {
        Client client = this._elasticsearchClientResolver.getClient();
        CreateIndexRequestBuilder createIndexRequestBuilder = CreateIndexAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        createIndexRequestBuilder.setIndex(createIndexRequest.getIndexName());
        createIndexRequestBuilder.setSource(createIndexRequest.getSource(), XContentType.JSON);
        return createIndexRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

