/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.CloseIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.engine.adapter.index.CloseIndexRequest;
import com.liferay.portal.search.engine.adapter.index.CloseIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndicesOptions;
import org.elasticsearch.action.admin.indices.close.CloseIndexAction;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CloseIndexRequestExecutor.class})
public class CloseIndexRequestExecutorImpl
implements CloseIndexRequestExecutor {
    private ElasticsearchClientResolver _elasticsearchClientResolver;
    private IndicesOptionsTranslator _indicesOptionsTranslator;

    @Override
    public CloseIndexResponse execute(CloseIndexRequest closeIndexRequest) {
        CloseIndexRequestBuilder closeIndexRequestBuilder = this.createCloseIndexRequestBuilder(closeIndexRequest);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)closeIndexRequestBuilder.get();
        return new CloseIndexResponse(acknowledgedResponse.isAcknowledged());
    }

    protected CloseIndexRequestBuilder createCloseIndexRequestBuilder(CloseIndexRequest closeIndexRequest) {
        CloseIndexRequestBuilder closeIndexRequestBuilder = CloseIndexAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this._elasticsearchClientResolver.getClient());
        closeIndexRequestBuilder.setIndices(closeIndexRequest.getIndexNames());
        IndicesOptions indicesOptions = closeIndexRequest.getIndicesOptions();
        if (indicesOptions != null) {
            closeIndexRequestBuilder.setIndicesOptions(this._indicesOptionsTranslator.translate(indicesOptions));
        }
        if (closeIndexRequest.getTimeout() > 0L) {
            TimeValue timeValue = TimeValue.timeValueMillis((long)closeIndexRequest.getTimeout());
            closeIndexRequestBuilder.setMasterNodeTimeout(timeValue);
            closeIndexRequestBuilder.setTimeout(timeValue);
        }
        return closeIndexRequestBuilder;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }

    @Reference(unbind="-")
    protected void setIndicesOptionsTranslator(IndicesOptionsTranslator indicesOptionsTranslator) {
        this._indicesOptionsTranslator = indicesOptionsTranslator;
    }
}

