/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchClientResolver;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document.BulkDocumentRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.util.LogUtil;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentItemResponse;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentResponse;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BulkDocumentRequestExecutor.class})
public class BulkDocumentRequestExecutorImpl
implements BulkDocumentRequestExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BulkDocumentRequestExecutorImpl.class);
    private BulkableDocumentRequestTranslator _bulkableDocumentRequestTranslator;
    private ElasticsearchClientResolver _elasticsearchClientResolver;

    @Override
    public BulkDocumentResponse execute(BulkDocumentRequest bulkDocumentRequest) {
        BulkRequestBuilder bulkRequestBuilder = this.createBulkRequestBuilder(bulkDocumentRequest);
        BulkResponse bulkResponse = (BulkResponse)bulkRequestBuilder.get();
        LogUtil.logActionResponse(_log, bulkResponse);
        TimeValue timeValue = bulkResponse.getTook();
        BulkDocumentResponse bulkDocumentResponse = new BulkDocumentResponse(timeValue.getMillis());
        for (BulkItemResponse bulkItemResponse : bulkResponse.getItems()) {
            BulkDocumentItemResponse bulkDocumentItemResponse = new BulkDocumentItemResponse();
            bulkDocumentResponse.addBulkDocumentItemResponse(bulkDocumentItemResponse);
            bulkDocumentItemResponse.setId(bulkItemResponse.getId());
            bulkDocumentItemResponse.setIndex(bulkItemResponse.getIndex());
            bulkDocumentItemResponse.setFailureMessage(bulkItemResponse.getFailureMessage());
            bulkDocumentItemResponse.setType(bulkItemResponse.getType());
            bulkDocumentItemResponse.setVersion(bulkItemResponse.getVersion());
            RestStatus restStatus = bulkItemResponse.status();
            if (bulkItemResponse.isFailed()) {
                bulkDocumentResponse.setErrors(true);
                BulkItemResponse.Failure bulkItemFailureResponse = bulkItemResponse.getFailure();
                bulkDocumentItemResponse.setAborted(bulkItemFailureResponse.isAborted());
                bulkDocumentItemResponse.setCause(bulkItemFailureResponse.getCause());
                restStatus = bulkItemFailureResponse.getStatus();
            }
            bulkDocumentItemResponse.setStatus(restStatus.getStatus());
        }
        return bulkDocumentResponse;
    }

    protected BulkRequestBuilder createBulkRequestBuilder(BulkDocumentRequest bulkDocumentRequest) {
        Client client = this._elasticsearchClientResolver.getClient();
        BulkRequestBuilder bulkRequestBuilder = BulkAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        if (bulkDocumentRequest.isRefresh()) {
            bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        for (BulkableDocumentRequest bulkableDocumentRequest : bulkDocumentRequest.getBulkableDocumentRequests()) {
            bulkableDocumentRequest.accept(request -> {
                if (request instanceof DeleteDocumentRequest) {
                    DeleteRequestBuilder deleteRequestBuilder = (DeleteRequestBuilder)this._bulkableDocumentRequestTranslator.translate((DeleteDocumentRequest)request);
                    bulkRequestBuilder.add(deleteRequestBuilder);
                } else if (request instanceof IndexDocumentRequest) {
                    IndexRequestBuilder indexRequestBuilder = (IndexRequestBuilder)this._bulkableDocumentRequestTranslator.translate((IndexDocumentRequest)request);
                    bulkRequestBuilder.add(indexRequestBuilder);
                } else if (request instanceof UpdateDocumentRequest) {
                    UpdateRequestBuilder updateRequestBuilder = (UpdateRequestBuilder)this._bulkableDocumentRequestTranslator.translate((UpdateDocumentRequest)request);
                    bulkRequestBuilder.add(updateRequestBuilder);
                } else {
                    throw new IllegalArgumentException("No translator available for: " + request);
                }
            });
        }
        return bulkRequestBuilder;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setBulkableDocumentRequestTranslator(BulkableDocumentRequestTranslator bulkableDocumentRequestTranslator) {
        this._bulkableDocumentRequestTranslator = bulkableDocumentRequestTranslator;
    }

    @Reference(unbind="-")
    protected void setElasticsearchClientResolver(ElasticsearchClientResolver elasticsearchClientResolver) {
        this._elasticsearchClientResolver = elasticsearchClientResolver;
    }
}

