/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.query;

import com.liferay.portal.search.elasticsearch6.internal.query.StringQueryTranslator;
import com.liferay.portal.search.query.Operator;
import com.liferay.portal.search.query.StringQuery;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={StringQueryTranslator.class})
public class StringQueryTranslatorImpl
implements StringQueryTranslator {
    @Override
    public QueryBuilder translate(StringQuery stringQuery) {
        QueryStringQueryBuilder queryStringQueryBuilder = QueryBuilders.queryStringQuery((String)stringQuery.getQuery());
        if (stringQuery.getAllowLeadingWildcard() != null) {
            queryStringQueryBuilder.allowLeadingWildcard(stringQuery.getAllowLeadingWildcard());
        }
        if (stringQuery.getAnalyzer() != null) {
            queryStringQueryBuilder.analyzer(stringQuery.getAnalyzer());
        }
        if (stringQuery.getAnalyzeWildcard() != null) {
            queryStringQueryBuilder.analyzeWildcard(stringQuery.getAnalyzeWildcard());
        }
        if (stringQuery.getAutoGenerateSynonymsPhraseQuery() != null) {
            queryStringQueryBuilder.autoGenerateSynonymsPhraseQuery(stringQuery.getAutoGenerateSynonymsPhraseQuery().booleanValue());
        }
        if (stringQuery.getDefaultField() != null) {
            queryStringQueryBuilder.defaultField(stringQuery.getDefaultField());
        }
        if (stringQuery.getDefaultOperator() != null) {
            Operator operator = stringQuery.getDefaultOperator();
            if (operator == Operator.OR) {
                queryStringQueryBuilder.defaultOperator(org.elasticsearch.index.query.Operator.OR);
            } else if (operator == Operator.AND) {
                queryStringQueryBuilder.defaultOperator(org.elasticsearch.index.query.Operator.AND);
            } else {
                throw new IllegalArgumentException("Invalid operator: " + operator);
            }
        }
        if (stringQuery.getEnablePositionIncrements() != null) {
            queryStringQueryBuilder.enablePositionIncrements(stringQuery.getEnablePositionIncrements().booleanValue());
        }
        if (stringQuery.getFuzziness() != null) {
            queryStringQueryBuilder.fuzziness(Fuzziness.build((Object)stringQuery.getFuzziness()));
        }
        if (stringQuery.getFuzzyMaxExpansions() != null) {
            queryStringQueryBuilder.fuzzyMaxExpansions(stringQuery.getFuzzyMaxExpansions().intValue());
        }
        if (stringQuery.getFuzzyPrefixLength() != null) {
            queryStringQueryBuilder.fuzzyPrefixLength(stringQuery.getFuzzyPrefixLength().intValue());
        }
        if (stringQuery.getFuzzyTranspositions() != null) {
            queryStringQueryBuilder.fuzzyTranspositions(stringQuery.getFuzzyTranspositions().booleanValue());
        }
        if (stringQuery.getLenient() != null) {
            queryStringQueryBuilder.lenient(stringQuery.getLenient());
        }
        if (stringQuery.getMaxDeterminedStates() != null) {
            queryStringQueryBuilder.maxDeterminizedStates(stringQuery.getMaxDeterminedStates().intValue());
        }
        if (stringQuery.getPhraseSlop() != null) {
            queryStringQueryBuilder.phraseSlop(stringQuery.getPhraseSlop().intValue());
        }
        if (stringQuery.getQuoteAnalyzer() != null) {
            queryStringQueryBuilder.quoteAnalyzer(stringQuery.getQuoteAnalyzer());
        }
        if (stringQuery.getQuoteFieldSuffix() != null) {
            queryStringQueryBuilder.quoteFieldSuffix(stringQuery.getQuoteFieldSuffix());
        }
        if (stringQuery.getRewrite() != null) {
            queryStringQueryBuilder.rewrite(stringQuery.getRewrite());
        }
        if (stringQuery.getTimeZone() != null) {
            queryStringQueryBuilder.timeZone(stringQuery.getTimeZone());
        }
        return queryStringQueryBuilder;
    }
}

