/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.legacy.query;

import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterTranslator;
import com.liferay.portal.kernel.search.query.QueryVisitor;
import com.liferay.portal.search.elasticsearch6.internal.legacy.query.BooleanQueryTranslator;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BooleanQueryTranslator.class})
public class BooleanQueryTranslatorImpl
implements BooleanQueryTranslator {
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected FilterTranslator<QueryBuilder> filterTranslator;

    @Override
    public QueryBuilder translate(BooleanQuery booleanQuery, QueryVisitor<QueryBuilder> queryVisitor) {
        BooleanFilter booleanFilter;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (BooleanClause clause : booleanQuery.clauses()) {
            this._addClause((BooleanClause<Query>)clause, boolQueryBuilder, queryVisitor);
        }
        if (!booleanQuery.isDefaultBoost()) {
            boolQueryBuilder.boost(booleanQuery.getBoost());
        }
        if ((booleanFilter = booleanQuery.getPreBooleanFilter()) == null) {
            return boolQueryBuilder;
        }
        BoolQueryBuilder wrapperBoolQueryBuilder = QueryBuilders.boolQuery();
        wrapperBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder);
        QueryBuilder filterQueryBuilder = (QueryBuilder)this.filterTranslator.translate((Filter)booleanFilter, null);
        wrapperBoolQueryBuilder.filter(filterQueryBuilder);
        return wrapperBoolQueryBuilder;
    }

    private void _addClause(BooleanClause<Query> clause, BoolQueryBuilder boolQuery, QueryVisitor<QueryBuilder> queryVisitor) {
        BooleanClauseOccur booleanClauseOccur = clause.getBooleanClauseOccur();
        Query query = (Query)clause.getClause();
        QueryBuilder queryBuilder = (QueryBuilder)query.accept(queryVisitor);
        if (booleanClauseOccur.equals(BooleanClauseOccur.MUST)) {
            boolQuery.must(queryBuilder);
            return;
        }
        if (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT)) {
            boolQuery.mustNot(queryBuilder);
            return;
        }
        if (booleanClauseOccur.equals(BooleanClauseOccur.SHOULD)) {
            boolQuery.should(queryBuilder);
            return;
        }
        throw new IllegalArgumentException();
    }
}

