/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.information;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch6.internal.ElasticsearchSearchEngine;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.connection.OperationMode;
import com.liferay.portal.search.engine.SearchEngineInformation;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.unit.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchEngineInformation.class})
public class ElasticsearchSearchEngineInformation
implements SearchEngineInformation {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected ElasticsearchSearchEngine elasticsearchSearchEngine;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchSearchEngineInformation.class);

    public String getClientVersionString() {
        return Version.CURRENT.toString();
    }

    public String getNodesString() {
        try {
            Client client = this.elasticsearchConnectionManager.getClient();
            if (client == null) {
                return "";
            }
            List<NodeInfo> nodeInfos = this._getClusterNodes(client);
            Stream stream = nodeInfos.stream();
            return stream.map(nodeInfo -> {
                DiscoveryNode node = nodeInfo.getNode();
                StringBundler sb = new StringBundler(5);
                sb.append(node.getName());
                sb.append(" ");
                sb.append("(");
                sb.append((Object)node.getVersion());
                sb.append(")");
                return sb.toString();
            }).collect(Collectors.joining(", "));
        }
        catch (Exception e) {
            _log.error((Object)"Unable to get node information", (Throwable)e);
            StringBundler sb = new StringBundler(4);
            sb.append("(");
            sb.append("Error: ");
            sb.append(e.toString());
            sb.append(")");
            return sb.toString();
        }
    }

    @Deprecated
    public String getStatusString() {
        StringBundler sb = new StringBundler(8);
        sb.append("Vendor: ");
        sb.append(this.getVendorString());
        sb.append(", ");
        sb.append("Client Version: ");
        sb.append(this.getClientVersionString());
        sb.append(", ");
        sb.append("Nodes: ");
        sb.append(this.getNodesString());
        return sb.toString();
    }

    public String getVendorString() {
        ElasticsearchConnection elasticsearchConnection = this.elasticsearchConnectionManager.getElasticsearchConnection();
        if (elasticsearchConnection.getOperationMode() == OperationMode.EMBEDDED) {
            return this.elasticsearchSearchEngine.getVendor() + " " + "(Embedded)";
        }
        return this.elasticsearchSearchEngine.getVendor();
    }

    private List<NodeInfo> _getClusterNodes(Client client) {
        AdminClient adminClient = client.admin();
        ClusterAdminClient clusterAdminClient = adminClient.cluster();
        NodesInfoRequestBuilder nodesInfoRequestBuilder = clusterAdminClient.prepareNodesInfo(new String[0]);
        TimeValue timeout = TimeValue.timeValueMillis((long)10000L);
        NodesInfoResponse nodesInfoResponse = (NodesInfoResponse)nodesInfoRequestBuilder.get(timeout);
        return nodesInfoResponse.getNodes();
    }
}

