/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.highlight;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.highlight.FieldConfig;
import com.liferay.portal.search.highlight.Highlight;
import com.liferay.portal.search.query.QueryTranslator;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;

public class HighlightTranslator {
    public HighlightBuilder translate(Highlight highlight, QueryTranslator<QueryBuilder> queryTranslator) {
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        List fieldConfigs = highlight.getFieldConfigs();
        fieldConfigs.stream().map(this::translate).forEach(arg_0 -> ((HighlightBuilder)highlightBuilder).field(arg_0));
        if (highlight.getForceSource() != null) {
            highlightBuilder.forceSource(highlight.getForceSource());
        }
        if (highlight.getFragmenter() != null) {
            highlightBuilder.fragmenter(highlight.getFragmenter());
        }
        if (highlight.getFragmentSize() != null) {
            highlightBuilder.fragmentSize(highlight.getFragmentSize());
        }
        if (highlight.getHighlighterType() != null) {
            highlightBuilder.highlighterType(highlight.getHighlighterType());
        }
        if (highlight.getHighlightFilter() != null) {
            highlightBuilder.highlightFilter(highlight.getHighlightFilter());
        }
        if (highlight.getHighlightQuery() != null) {
            highlightBuilder.highlightQuery((QueryBuilder)queryTranslator.translate(highlight.getHighlightQuery()));
        }
        if (highlight.getHighlighterType() != null) {
            highlightBuilder.highlighterType(highlight.getHighlighterType());
        }
        if (highlight.getNumOfFragments() != null) {
            highlightBuilder.numOfFragments(highlight.getNumOfFragments());
        }
        if (ArrayUtil.isNotEmpty((Object[])highlight.getPreTags())) {
            highlightBuilder.preTags(highlight.getPreTags());
        }
        if (ArrayUtil.isNotEmpty((Object[])highlight.getPostTags())) {
            highlightBuilder.postTags(highlight.getPostTags());
        }
        if (highlight.getRequireFieldMatch() != null) {
            highlightBuilder.requireFieldMatch(highlight.getRequireFieldMatch());
        }
        return highlightBuilder;
    }

    protected HighlightBuilder.Field translate(FieldConfig fieldConfig) {
        HighlightBuilder.Field field = new HighlightBuilder.Field(fieldConfig.getField());
        if (fieldConfig.getFragmentOffset() != null) {
            field.fragmentOffset(fieldConfig.getFragmentOffset().intValue());
        }
        if (fieldConfig.getFragmentSize() != null) {
            field.fragmentSize(fieldConfig.getFragmentSize());
        }
        if (fieldConfig.getNumFragments() != null) {
            field.numOfFragments(fieldConfig.getNumFragments());
        }
        return field;
    }
}

