/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.geolocation;

import com.liferay.portal.search.geolocation.CircleShape;
import com.liferay.portal.search.geolocation.Coordinate;
import com.liferay.portal.search.geolocation.EnvelopeShape;
import com.liferay.portal.search.geolocation.GeoDistance;
import com.liferay.portal.search.geolocation.GeometryCollectionShape;
import com.liferay.portal.search.geolocation.LineStringShape;
import com.liferay.portal.search.geolocation.MultiLineStringShape;
import com.liferay.portal.search.geolocation.MultiPointShape;
import com.liferay.portal.search.geolocation.MultiPolygonShape;
import com.liferay.portal.search.geolocation.Orientation;
import com.liferay.portal.search.geolocation.PointShape;
import com.liferay.portal.search.geolocation.PolygonShape;
import com.liferay.portal.search.geolocation.Shape;
import com.liferay.portal.search.geolocation.ShapeTranslator;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.geo.builders.CircleBuilder;
import org.elasticsearch.common.geo.builders.EnvelopeBuilder;
import org.elasticsearch.common.geo.builders.GeometryCollectionBuilder;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.MultiLineStringBuilder;
import org.elasticsearch.common.geo.builders.MultiPointBuilder;
import org.elasticsearch.common.geo.builders.MultiPolygonBuilder;
import org.elasticsearch.common.geo.builders.PointBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;

public class ElasticsearchShapeTranslator
implements ShapeTranslator<ShapeBuilder<?, ?>> {
    public CircleBuilder translate(CircleShape circleShape) {
        GeoDistance radiusGeoDistance = circleShape.getRadius();
        return ((CircleBuilder)new CircleBuilder().center(this.translate(circleShape.getCenter())).coordinates(this.translate(circleShape.getCoordinates()))).radius(radiusGeoDistance.getDistance(), String.valueOf(radiusGeoDistance.getDistanceUnit()));
    }

    public EnvelopeBuilder translate(EnvelopeShape envelopeShape) {
        return (EnvelopeBuilder)new EnvelopeBuilder(this.translate(envelopeShape.getTopLeft()), this.translate(envelopeShape.getBottomRight())).coordinates(this.translate(envelopeShape.getCoordinates()));
    }

    public GeometryCollectionBuilder translate(GeometryCollectionShape geometryCollectionShape) {
        GeometryCollectionBuilder geometryCollectionBuilder = new GeometryCollectionBuilder();
        geometryCollectionBuilder.coordinates(this.translate(geometryCollectionShape.getCoordinates()));
        List shapes = geometryCollectionShape.getShapes();
        shapes.stream().map(this::translate).forEach(arg_0 -> ((GeometryCollectionBuilder)geometryCollectionBuilder).shape(arg_0));
        return geometryCollectionBuilder;
    }

    public LineStringBuilder translate(LineStringShape lineStringShape) {
        return new LineStringBuilder(this.translate(lineStringShape.getCoordinates()));
    }

    public MultiLineStringBuilder translate(MultiLineStringShape multiLineStringShape) {
        MultiLineStringBuilder multiLineStringBuilder = new MultiLineStringBuilder();
        multiLineStringBuilder.coordinates(this.translate(multiLineStringShape.getCoordinates()));
        List lineStringShapes = multiLineStringShape.getLineStringShapes();
        lineStringShapes.stream().map(this::translate).forEach(arg_0 -> ((MultiLineStringBuilder)multiLineStringBuilder).linestring(arg_0));
        return multiLineStringBuilder;
    }

    public MultiPointBuilder translate(MultiPointShape multiPointShape) {
        return new MultiPointBuilder(this.translate(multiPointShape.getCoordinates()));
    }

    public MultiPolygonBuilder translate(MultiPolygonShape multiPolygonShape) {
        MultiPolygonBuilder multiPolygonBuilder = new MultiPolygonBuilder(this.translate(multiPolygonShape.getOrientation()));
        multiPolygonBuilder.coordinates(this.translate(multiPolygonShape.getCoordinates()));
        List polygonShapes = multiPolygonShape.getPolygonShapes();
        polygonShapes.stream().map(this::translate).forEach(arg_0 -> ((MultiPolygonBuilder)multiPolygonBuilder).polygon(arg_0));
        return multiPolygonBuilder;
    }

    public PointBuilder translate(PointShape pointShape) {
        List coordinates = pointShape.getCoordinates();
        PointBuilder pointBuilder = new PointBuilder();
        coordinates.stream().map(this::translate).forEach(arg_0 -> ((PointBuilder)pointBuilder).coordinate(arg_0));
        return pointBuilder;
    }

    public PolygonBuilder translate(PolygonShape polygonShape) {
        PolygonBuilder polygonBuilder = new PolygonBuilder(this.translate(polygonShape.getShell()), this.translate(polygonShape.getOrientation()));
        polygonBuilder.coordinates(this.translate(polygonShape.getCoordinates()));
        List holesLineStringShapes = polygonShape.getHoles();
        holesLineStringShapes.stream().map(this::translate).forEach(arg_0 -> ((PolygonBuilder)polygonBuilder).hole(arg_0));
        return polygonBuilder;
    }

    protected org.locationtech.jts.geom.Coordinate translate(Coordinate coordinate) {
        return new org.locationtech.jts.geom.Coordinate(coordinate.getX(), coordinate.getY(), coordinate.getZ());
    }

    protected List<org.locationtech.jts.geom.Coordinate> translate(List<Coordinate> coordinates) {
        return coordinates.stream().map(this::translate).collect(Collectors.toList());
    }

    protected ShapeBuilder.Orientation translate(Orientation orientation) {
        if (orientation == Orientation.LEFT) {
            return ShapeBuilder.Orientation.LEFT;
        }
        if (orientation == Orientation.RIGHT) {
            return ShapeBuilder.Orientation.RIGHT;
        }
        throw new IllegalArgumentException("Invalid Orientation: " + orientation);
    }

    protected ShapeBuilder<?, ?> translate(Shape shape) {
        return (ShapeBuilder)shape.accept((ShapeTranslator)this);
    }
}

