/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.facet;

import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.search.elasticsearch6.internal.facet.ElasticsearchFacetFieldCollector;
import com.liferay.portal.search.elasticsearch6.internal.facet.MultiBucketsAggregationFacetCollector;
import com.liferay.portal.search.elasticsearch6.internal.facet.RangeFacetCollector;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.bucket.range.Range;

public class FacetCollectorFactory {
    public FacetCollector getFacetCollector(Aggregation aggregation) {
        if (aggregation instanceof InternalFilter) {
            InternalFilter internalFilter = (InternalFilter)aggregation;
            InternalAggregations aggregations = internalFilter.getAggregations();
            return this.getFacetCollector(aggregations.get(aggregation.getName()));
        }
        if (aggregation instanceof Range) {
            return new RangeFacetCollector((Range)aggregation);
        }
        if (aggregation instanceof MultiBucketsAggregation) {
            return new MultiBucketsAggregationFacetCollector((MultiBucketsAggregation)aggregation);
        }
        return new ElasticsearchFacetFieldCollector(aggregation);
    }
}

