/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.connection;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch6.internal.connection.BaseElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.connection.OperationMode;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexFactory;
import com.liferay.portal.search.elasticsearch6.settings.SettingsContributor;
import com.liferay.portal.search.elasticsearch6.settings.XPackSecuritySettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration"}, immediate=true, property={"operation.mode=REMOTE"}, service={ElasticsearchConnection.class})
public class RemoteElasticsearchConnection
extends BaseElasticsearchConnection {
    @Reference
    protected Props props;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected volatile XPackSecuritySettings xPackSecuritySettings;
    private static final Log _log = LogFactoryUtil.getLog(RemoteElasticsearchConnection.class);
    private Set<String> _transportAddresses = new HashSet<String>();

    @Override
    public OperationMode getOperationMode() {
        return OperationMode.REMOTE;
    }

    @Override
    @Reference(unbind="-")
    public void setIndexFactory(IndexFactory indexFactory) {
        super.setIndexFactory(indexFactory);
    }

    public void setTransportAddresses(Set<String> transportAddresses) {
        this._transportAddresses = transportAddresses;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.replaceElasticsearchConfiguration(properties);
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(operation.mode=REMOTE)")
    protected void addSettingsContributor(SettingsContributor settingsContributor) {
        super.addSettingsContributor(settingsContributor);
    }

    protected void addTransportAddress(TransportClient transportClient, String transportAddress) throws UnknownHostException {
        String[] transportAddressParts = StringUtil.split((String)transportAddress, (String)":");
        String host = transportAddressParts[0];
        int port = GetterUtil.getInteger((String)transportAddressParts[1]);
        InetAddress inetAddress = InetAddressUtil.getInetAddressByName((String)host);
        transportClient.addTransportAddress(new TransportAddress(inetAddress, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Client createClient() {
        if (this._transportAddresses.isEmpty()) {
            throw new IllegalStateException("There must be at least one transport address");
        }
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        Class<?> clazz = this.getClass();
        thread.setContextClassLoader(clazz.getClassLoader());
        try {
            TransportClient transportClient = this.createTransportClient();
            for (String transportAddress : this._transportAddresses) {
                try {
                    this.addTransportAddress(transportClient, transportAddress);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to add transport address " + transportAddress), (Throwable)e);
                }
            }
            TransportClient transportClient2 = transportClient;
            return transportClient2;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    protected TransportClient createTransportClient() {
        if (this.xPackSecuritySettings != null && this.xPackSecuritySettings.requiresXPackSecurity()) {
            return new PreBuiltXPackTransportClient(this.settingsBuilder.build(), new Class[0]);
        }
        return new PreBuiltTransportClient(this.settingsBuilder.build(), new Class[0]);
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties) {
        this.close();
    }

    @Override
    protected void loadRequiredDefaultConfigurations() {
        this.settingsBuilder.put("client.transport.ignore_cluster_name", this.elasticsearchConfiguration.clientTransportIgnoreClusterName());
        this.settingsBuilder.put("client.transport.nodes_sampler_interval", this.elasticsearchConfiguration.clientTransportNodesSamplerInterval());
        this.settingsBuilder.put("client.transport.ping_timeout", this.elasticsearchConfiguration.clientTransportPingTimeout());
        this.settingsBuilder.put("client.transport.sniff", this.elasticsearchConfiguration.clientTransportSniff());
        this.settingsBuilder.put("cluster.name", this.elasticsearchConfiguration.clusterName());
        this.settingsBuilder.put("request.headers.X-Found-Cluster", this.elasticsearchConfiguration.clusterName());
    }

    @Modified
    protected synchronized void modified(Map<String, Object> properties) {
        this.replaceElasticsearchConfiguration(properties);
        if (this.isConnected()) {
            this.close();
        }
        if (!this.isConnected() && this.elasticsearchConfiguration.operationMode() == com.liferay.portal.search.elasticsearch6.configuration.OperationMode.REMOTE) {
            this.connect();
        }
    }

    @Override
    protected void removeSettingsContributor(SettingsContributor settingsContributor) {
        super.removeSettingsContributor(settingsContributor);
    }

    protected void replaceElasticsearchConfiguration(Map<String, Object> properties) {
        this.elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        Object[] transportAddresses = this.elasticsearchConfiguration.transportAddresses();
        this.setTransportAddresses(SetUtil.fromArray((Object[])transportAddresses));
    }
}

