/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.cluster;

import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterTokenTransitionListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.search.elasticsearch6.internal.cluster.ReplicasClusterContext;
import com.liferay.portal.search.elasticsearch6.internal.cluster.ReplicasClusterListener;
import com.liferay.portal.search.elasticsearch6.internal.cluster.ReplicasManager;
import com.liferay.portal.search.elasticsearch6.internal.cluster.ReplicasManagerImpl;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.connection.OperationMode;
import com.liferay.portal.search.index.IndexNameBuilder;
import java.util.List;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ElasticsearchCluster.class})
public class ElasticsearchCluster {
    @Reference
    protected CompanyLocalService companyLocalService;
    @Reference
    protected IndexNameBuilder indexNameBuilder;
    @Reference
    private ClusterExecutor _clusterExecutor;
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private ElasticsearchConnectionManager _elasticsearchConnectionManager;
    private ReplicasClusterListener _replicasClusterListener;

    @Activate
    protected void activate() {
        this._replicasClusterListener = new ReplicasClusterListener(new ReplicasClusterContextImpl());
        this._clusterExecutor.addClusterEventListener((ClusterEventListener)this._replicasClusterListener);
        this._clusterMasterExecutor.addClusterMasterTokenTransitionListener((ClusterMasterTokenTransitionListener)this._replicasClusterListener);
    }

    @Deactivate
    protected void deactivate() {
        this._clusterExecutor.removeClusterEventListener((ClusterEventListener)this._replicasClusterListener);
        this._clusterMasterExecutor.removeClusterMasterTokenTransitionListener((ClusterMasterTokenTransitionListener)this._replicasClusterListener);
        this._replicasClusterListener = null;
    }

    protected class ReplicasClusterContextImpl
    implements ReplicasClusterContext {
        protected ReplicasClusterContextImpl() {
        }

        @Override
        public int getClusterSize() {
            List clusterNodes = ElasticsearchCluster.this._clusterExecutor.getClusterNodes();
            return clusterNodes.size();
        }

        @Override
        public ReplicasManager getReplicasManager() {
            ElasticsearchConnection elasticsearchConnection = this.getActiveElasticsearchConnection();
            Client client = elasticsearchConnection.getClient();
            AdminClient adminClient = client.admin();
            return new ReplicasManagerImpl(adminClient.indices());
        }

        @Override
        public String[] getTargetIndexNames() {
            List companies = ElasticsearchCluster.this.companyLocalService.getCompanies();
            String[] targetIndexNames = new String[companies.size() + 1];
            for (int i = 0; i < targetIndexNames.length - 1; ++i) {
                Company company = (Company)companies.get(i);
                targetIndexNames[i] = ElasticsearchCluster.this.indexNameBuilder.getIndexName(company.getCompanyId());
            }
            targetIndexNames[targetIndexNames.length - 1] = ElasticsearchCluster.this.indexNameBuilder.getIndexName(0L);
            return targetIndexNames;
        }

        @Override
        public boolean isEmbeddedOperationMode() {
            ElasticsearchConnection elasticsearchConnection = this.getActiveElasticsearchConnection();
            OperationMode operationMode = elasticsearchConnection.getOperationMode();
            return operationMode == OperationMode.EMBEDDED;
        }

        @Override
        public boolean isMaster() {
            return ElasticsearchCluster.this._clusterMasterExecutor.isMaster();
        }

        protected ElasticsearchConnection getActiveElasticsearchConnection() {
            return ElasticsearchCluster.this._elasticsearchConnectionManager.getElasticsearchConnection();
        }
    }
}

