/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.aggregation;

import com.liferay.portal.search.aggregation.AggregationResult;
import com.liferay.portal.search.aggregation.AggregationVisitor;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregationVisitor;
import com.liferay.portal.search.elasticsearch6.internal.aggregation.AggregationResultTranslatorFactory;
import com.liferay.portal.search.elasticsearch6.internal.aggregation.PipelineAggregationResultTranslatorFactory;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;

public class ElasticsearchAggregationResultsTranslator {
    private final AggregationLookup _aggregationLookup;
    private final AggregationResultTranslatorFactory _aggregationResultTranslatorFactory;
    private final PipelineAggregationLookup _pipelineAggregationLookup;
    private final PipelineAggregationResultTranslatorFactory _pipelineAggregationResultTranslatorFactory;

    public ElasticsearchAggregationResultsTranslator(AggregationResultTranslatorFactory aggregationResultTranslatorFactory, PipelineAggregationResultTranslatorFactory pipelineAggregationResultTranslatorFactory, AggregationLookup aggregationLookup, PipelineAggregationLookup pipelineAggregationLookup) {
        this._aggregationResultTranslatorFactory = aggregationResultTranslatorFactory;
        this._pipelineAggregationResultTranslatorFactory = pipelineAggregationResultTranslatorFactory;
        this._aggregationLookup = aggregationLookup;
        this._pipelineAggregationLookup = pipelineAggregationLookup;
    }

    public Stream<AggregationResult> translate(Aggregations elasticsearchAggregations) {
        Stream<Aggregation> stream = this.getElasticsearchAggregations(elasticsearchAggregations);
        return stream.map(this::translate).filter(aggregationResult -> aggregationResult != null);
    }

    protected Stream<Aggregation> getElasticsearchAggregations(Aggregations aggregations) {
        List list = aggregations.asList();
        return list.stream();
    }

    protected AggregationResult translate(Aggregation elasticsearchAggregation) {
        String name = elasticsearchAggregation.getName();
        com.liferay.portal.search.aggregation.Aggregation aggregation = this._aggregationLookup.lookup(name);
        if (aggregation != null) {
            return (AggregationResult)aggregation.accept((AggregationVisitor)this._aggregationResultTranslatorFactory.createAggregationResultTranslator(elasticsearchAggregation));
        }
        PipelineAggregation pipelineAggregation = this._pipelineAggregationLookup.lookup(name);
        if (pipelineAggregation != null) {
            return (AggregationResult)pipelineAggregation.accept((PipelineAggregationVisitor)this._pipelineAggregationResultTranslatorFactory.createPipelineAggregationResultTranslator(elasticsearchAggregation));
        }
        return null;
    }

    public static interface PipelineAggregationLookup {
        public PipelineAggregation lookup(String var1);
    }

    public static interface AggregationLookup {
        public com.liferay.portal.search.aggregation.Aggregation lookup(String var1);
    }
}

