/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.search.suggest.SpellCheckIndexWriter;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.suggest.BaseGenericSpellCheckIndexWriter;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.impl=Elasticsearch"}, service={SpellCheckIndexWriter.class})
public class ElasticsearchSpellCheckIndexWriter
extends BaseGenericSpellCheckIndexWriter {
    private IndexNameBuilder _indexNameBuilder;
    private Localization _localization;
    private SearchEngineAdapter _searchEngineAdapter;

    public void clearQuerySuggestionDictionaryIndexes(SearchContext searchContext) throws SearchException {
        try {
            this.deleteDocuments(searchContext, "querySuggestion");
        }
        catch (Exception e) {
            throw new SearchException("Unable to clear query suggestions", (Throwable)e);
        }
    }

    public void clearSpellCheckerDictionaryIndexes(SearchContext searchContext) throws SearchException {
        try {
            this.deleteDocuments(searchContext, "spellChecker");
        }
        catch (Exception e) {
            throw new SearchException("Unable to to clear spell checks", (Throwable)e);
        }
    }

    protected void addDocument(String documentType, SearchContext searchContext, Document document) {
        String indexName = this._indexNameBuilder.getIndexName(searchContext.getCompanyId());
        IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
        indexDocumentRequest.setType("LiferayDocumentType");
        this._searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
    }

    protected void addDocuments(String documentType, SearchContext searchContext, Collection<Document> documents) {
        String indexName = this._indexNameBuilder.getIndexName(searchContext.getCompanyId());
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        documents.forEach(document -> {
            IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
            indexDocumentRequest.setType("LiferayDocumentType");
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
        });
        this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }

    protected Document createDocument(long companyId, long groupId, String languageId, String keywords, float weight, String keywordFieldName, String typeFieldValue, int maxNGramLength) {
        Document document = this.createDocument();
        Localization localization = this.getLocalization();
        String localizedName = localization.getLocalizedName(keywordFieldName, languageId);
        document.addKeyword(localizedName, keywords);
        document.addKeyword("companyId", companyId);
        document.addKeyword("groupId", groupId);
        document.addKeyword("languageId", languageId);
        document.addKeyword("priority", String.valueOf(weight));
        document.addKeyword("type", typeFieldValue);
        document.addKeyword("uid", this.getUID(companyId, keywordFieldName, languageId, keywords, new String[0]));
        return document;
    }

    protected void deleteDocuments(SearchContext searchContext, String typeFieldValue) {
        try {
            String indexName = this._indexNameBuilder.getIndexName(searchContext.getCompanyId());
            TermFilter termFilter = new TermFilter("type", typeFieldValue);
            BooleanFilter booleanFilter = new BooleanFilter();
            booleanFilter.add((Filter)termFilter, BooleanClauseOccur.MUST);
            MatchAllQuery matchAllQuery = new MatchAllQuery();
            BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
            booleanQuery.setPreBooleanFilter(booleanFilter);
            booleanQuery.add((Query)matchAllQuery, BooleanClauseOccur.MUST);
            DeleteByQueryDocumentRequest deleteByQueryDocumentRequest = new DeleteByQueryDocumentRequest((Query)matchAllQuery, new String[]{indexName});
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                deleteByQueryDocumentRequest.setRefresh(true);
            }
            this._searchEngineAdapter.execute((DocumentRequest)deleteByQueryDocumentRequest);
        }
        catch (ParseException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    protected Localization getLocalization() {
        if (this._localization != null) {
            return this._localization;
        }
        return LocalizationUtil.getLocalization();
    }

    @Reference(unbind="-")
    protected void setIndexNameBuilder(IndexNameBuilder indexNameBuilder) {
        this._indexNameBuilder = indexNameBuilder;
    }

    protected void setLocalization(Localization localization) {
        this._localization = localization;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setSearchEngineAdapter(SearchEngineAdapter searchEngineAdapter) {
        this._searchEngineAdapter = searchEngineAdapter;
    }
}

