/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexSearcher;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.suggest.QuerySuggester;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.pipeline.PipelineAggregation;
import com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.legacy.searcher.SearchResponseBuilderFactory;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchResponseBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration"}, immediate=true, property={"search.engine.impl=Elasticsearch"}, service={IndexSearcher.class})
public class ElasticsearchIndexSearcher
extends BaseIndexSearcher {
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchIndexSearcher.class);
    private volatile ElasticsearchConfiguration _elasticsearchConfiguration;
    private IndexNameBuilder _indexNameBuilder;
    private boolean _logExceptionsOnly;
    private Props _props;
    private SearchEngineAdapter _searchEngineAdapter;
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    private SearchResponseBuilderFactory _searchResponseBuilderFactory;

    public String getQueryString(SearchContext searchContext, Query query) {
        return this._searchEngineAdapter.getQueryString(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hits search(SearchContext searchContext, Query query) {
        Hits hits;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            int end = searchContext.getEnd();
            int start = searchContext.getStart();
            SearchRequest searchRequest = this.getSearchRequest(searchContext);
            Integer from = searchRequest.getFrom();
            Integer size = searchRequest.getSize();
            if (from == null && size != null) {
                end = size;
                start = 0;
            } else if (from != null && size != null) {
                end = from + size;
                start = from;
            }
            if (start == -1) {
                start = 0;
            } else if (start < 0) {
                throw new IllegalArgumentException("Invalid start " + start);
            }
            if (end == -1) {
                end = GetterUtil.getInteger((String)this._props.get("index.search.limit"));
            } else if (end < 0) {
                throw new IllegalArgumentException("Invalid end " + end);
            }
            SearchResponseBuilder searchResponseBuilder = this._getSearchResponseBuilder(searchContext);
            Hits hits2 = null;
            while (true) {
                SearchSearchRequest searchSearchRequest = this.createSearchSearchRequest(searchRequest, searchContext, query, start, end);
                SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this._searchEngineAdapter.execute((com.liferay.portal.search.engine.adapter.search.SearchRequest)searchSearchRequest);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"The search engine processed ", searchSearchResponse.getSearchRequestString(), " in ", searchSearchResponse.getExecutionTime() + " ms"}));
                }
                this.populateResponse(searchSearchResponse, searchResponseBuilder);
                searchResponseBuilder.searchHits(searchSearchResponse.getSearchHits());
                hits2 = searchSearchResponse.getHits();
                Document[] documents = hits2.getDocs();
                if (documents.length != 0 || start == 0) break;
                int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)start, (int)end, (int)hits2.getLength());
                start = startAndEnd[0];
                end = startAndEnd[1];
            }
            hits2.setStart(stopWatch.getStartTime());
            hits = hits2;
        }
        catch (RuntimeException re) {
            HitsImpl hitsImpl;
            try {
                if (!this.handle(re)) {
                    if (this._logExceptionsOnly) {
                        _log.error((Object)re, (Throwable)re);
                    } else {
                        throw re;
                    }
                }
                hitsImpl = new HitsImpl();
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
            }
            return hitsImpl;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
        }
        return hits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long searchCount(SearchContext searchContext, Query query) {
        long l;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            CountSearchRequest countSearchRequest = this.createCountSearchRequest(searchContext, query);
            CountSearchResponse countSearchResponse = (CountSearchResponse)this._searchEngineAdapter.execute((com.liferay.portal.search.engine.adapter.search.SearchRequest)countSearchRequest);
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"The search engine processed ", countSearchResponse.getSearchRequestString(), " in ", countSearchResponse.getExecutionTime() + " ms"}));
            }
            this.populateResponse((BaseSearchResponse)countSearchResponse, this._getSearchResponseBuilder(searchContext));
            l = countSearchResponse.getCount();
        }
        catch (RuntimeException re) {
            long l2;
            try {
                if (!this.handle(re)) {
                    if (this._logExceptionsOnly) {
                        _log.error((Object)re, (Throwable)re);
                    } else {
                        throw re;
                    }
                }
                l2 = 0L;
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
            }
            return l2;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
        }
        return l;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    public void setQuerySuggester(QuerySuggester querySuggester) {
        super.setQuerySuggester(querySuggester);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        this._logExceptionsOnly = this._elasticsearchConfiguration.logExceptionsOnly();
    }

    protected CountSearchRequest createCountSearchRequest(SearchContext searchContext, Query query) {
        CountSearchRequest countSearchRequest = new CountSearchRequest();
        this.prepare((BaseSearchRequest)countSearchRequest, this.getSearchRequest(searchContext), query, searchContext);
        return countSearchRequest;
    }

    protected SearchSearchRequest createSearchSearchRequest(SearchRequest searchRequest, SearchContext searchContext, Query query, int start, int end) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        this.prepare((BaseSearchRequest)searchSearchRequest, searchRequest, query, searchContext);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        searchSearchRequest.setAlternateUidFieldName(queryConfig.getAlternateUidFieldName());
        searchSearchRequest.setBasicFacetSelection(searchRequest.isBasicFacetSelection());
        searchSearchRequest.putAllFacets(searchContext.getFacets());
        searchSearchRequest.setGroupBy(searchContext.getGroupBy());
        searchSearchRequest.setGroupByRequests((Collection)searchRequest.getGroupByRequests());
        searchSearchRequest.setHighlightEnabled(queryConfig.isHighlightEnabled());
        searchSearchRequest.setHighlightFieldNames(queryConfig.getHighlightFieldNames());
        searchSearchRequest.setHighlightFragmentSize(queryConfig.getHighlightFragmentSize());
        searchSearchRequest.setHighlightSnippetSize(queryConfig.getHighlightSnippetSize());
        searchSearchRequest.setLocale(queryConfig.getLocale());
        searchSearchRequest.setHighlightRequireFieldMatch(queryConfig.isHighlightRequireFieldMatch());
        boolean luceneSyntax = GetterUtil.getBoolean((Object)searchContext.getAttribute("search.lucene.syntax"));
        searchSearchRequest.setLuceneSyntax(luceneSyntax);
        String preference = (String)((Object)searchContext.getAttribute("elasticsearch.search.request.preference"));
        if (!Validator.isBlank((String)preference)) {
            searchSearchRequest.setPreference(preference);
        }
        searchSearchRequest.setScoreEnabled(queryConfig.isScoreEnabled());
        searchSearchRequest.setSelectedFieldNames(queryConfig.getSelectedFieldNames());
        int size = end - start;
        searchSearchRequest.setSize(Integer.valueOf(size));
        searchSearchRequest.setStart(Integer.valueOf(start));
        searchSearchRequest.setSorts(searchContext.getSorts());
        searchSearchRequest.setSorts((Collection)searchRequest.getSorts());
        searchSearchRequest.setStats(searchContext.getStats());
        return searchSearchRequest;
    }

    protected String[] getIndexes(SearchRequest searchRequest, SearchContext searchContext) {
        List indexes = searchRequest.getIndexes();
        if (!indexes.isEmpty()) {
            return indexes.toArray(new String[0]);
        }
        String indexName = this._indexNameBuilder.getIndexName(searchContext.getCompanyId());
        return new String[]{indexName};
    }

    protected SearchRequest getSearchRequest(SearchContext searchContext) {
        SearchRequestBuilder searchRequestBuilder = this._getSearchRequestBuilder(searchContext);
        return searchRequestBuilder.build();
    }

    protected boolean handle(Exception e) {
        Throwable throwable = e.getCause();
        if (throwable == null) {
            return false;
        }
        String message = throwable.getMessage();
        if (message == null) {
            return false;
        }
        if (message.contains("Fielddata is disabled on text fields by default.")) {
            _log.error((Object)"Unable to aggregate facet on a nonkeyword field", (Throwable)e);
            return true;
        }
        return false;
    }

    protected void populateResponse(BaseSearchResponse baseSearchResponse, SearchResponseBuilder searchResponseBuilder) {
        searchResponseBuilder.aggregationResultsMap(baseSearchResponse.getAggregationResultsMap()).count(baseSearchResponse.getCount()).requestString(baseSearchResponse.getSearchRequestString()).responseString(baseSearchResponse.getSearchResponseString()).statsResponseMap(baseSearchResponse.getStatsResponseMap());
    }

    protected void populateResponse(SearchSearchResponse searchSearchResponse, SearchResponseBuilder searchResponseBuilder) {
        this.populateResponse((BaseSearchResponse)searchSearchResponse, searchResponseBuilder);
        searchResponseBuilder.groupByResponses(searchSearchResponse.getGroupByResponses());
    }

    protected void prepare(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest, Query query, SearchContext searchContext) {
        baseSearchRequest.addComplexQueryParts((Collection)searchRequest.getComplexQueryParts());
        baseSearchRequest.setExplain(Boolean.valueOf(searchRequest.isExplain()));
        baseSearchRequest.setIncludeResponseString(searchRequest.isIncludeResponseString());
        baseSearchRequest.setPostFilterQuery(searchRequest.getPostFilterQuery());
        baseSearchRequest.setRescoreQuery(searchRequest.getRescoreQuery());
        baseSearchRequest.setStatsRequests((Collection)searchRequest.getStatsRequests());
        this.setAggregations(baseSearchRequest, searchRequest);
        this.setIndexNames(baseSearchRequest, searchRequest, searchContext);
        this.setLegacyQuery(baseSearchRequest, query);
        this.setLegacyPostFilter(baseSearchRequest, query);
        this.setPipelineAggregations(baseSearchRequest, searchRequest);
        this.setQuery(baseSearchRequest, searchRequest);
    }

    protected void setAggregations(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest) {
        Map map = searchRequest.getAggregationsMap();
        for (Aggregation aggregation : map.values()) {
            baseSearchRequest.addAggregation(aggregation);
        }
    }

    @Reference(unbind="-")
    protected void setIndexNameBuilder(IndexNameBuilder indexNameBuilder) {
        this._indexNameBuilder = indexNameBuilder;
    }

    protected void setIndexNames(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest, SearchContext searchContext) {
        baseSearchRequest.setIndexNames(this.getIndexes(searchRequest, searchContext));
    }

    protected void setLegacyPostFilter(BaseSearchRequest baseSearchRequest, Query query) {
        if (query != null) {
            baseSearchRequest.setPostFilter(query.getPostFilter());
        }
    }

    protected void setLegacyQuery(BaseSearchRequest baseSearchRequest, Query query) {
        baseSearchRequest.setQuery(query);
    }

    protected void setPipelineAggregations(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest) {
        Map map = searchRequest.getPipelineAggregationsMap();
        for (PipelineAggregation aggregation : map.values()) {
            baseSearchRequest.addPipelineAggregation(aggregation);
        }
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }

    protected void setQuery(BaseSearchRequest baseSearchRequest, SearchRequest searchRequest) {
        baseSearchRequest.setQuery(searchRequest.getQuery());
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    protected void setSearchEngineAdapter(SearchEngineAdapter searchEngineAdapter) {
        this._searchEngineAdapter = searchEngineAdapter;
    }

    @Reference(unbind="-")
    protected void setSearchRequestBuilderFactory(SearchRequestBuilderFactory searchRequestBuilderFactory) {
        this._searchRequestBuilderFactory = searchRequestBuilderFactory;
    }

    @Reference(unbind="-")
    protected void setSearchResponseBuilderFactory(SearchResponseBuilderFactory searchResponseBuilderFactory) {
        this._searchResponseBuilderFactory = searchResponseBuilderFactory;
    }

    private SearchRequestBuilder _getSearchRequestBuilder(SearchContext searchContext) {
        return this._searchRequestBuilderFactory.builder(searchContext);
    }

    private SearchResponseBuilder _getSearchResponseBuilder(SearchContext searchContext) {
        return this._searchResponseBuilderFactory.builder(searchContext);
    }
}

