/*
 * Copyright 2017 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright (C) 2017 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;



import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;



/**
 * This enum defines a set of message keys for messages in the
 * com.unboundid.ldap.sdk.unboundidds.logs package, which correspond to messages in the
 * unboundid-ldapsdk-log.properties properties file.
 * <BR><BR>
 * This source file was generated from the properties file.
 * Do not edit it directly.
 */
enum LogMessages
{
  /**
   * The log message string does not include a recognized access log message type.
   */
  ERR_LOG_MESSAGE_INVALID_ACCESS_MESSAGE_TYPE("The log message string does not include a recognized access log message type."),



  /**
   * The log message string appears to contain information about an operation for which replication assurance processing had been completed, but the message did not have a recognized operation type.
   */
  ERR_LOG_MESSAGE_INVALID_ASSURANCE_COMPLETE_OPERATION_TYPE("The log message string appears to contain information about an operation for which replication assurance processing had been completed, but the message did not have a recognized operation type."),



  /**
   * The log message string appears to contain an invalid escaped character in token ''{0}'' because it contains a backslash not followed by two hexadecimal digits.
   */
  ERR_LOG_MESSAGE_INVALID_ESCAPED_CHARACTER("The log message string appears to contain an invalid escaped character in token ''{0}'' because it contains a backslash not followed by two hexadecimal digits."),



  /**
   * The log message string appears to contain a failed forwarded operation but did not have a recognized operation type.
   */
  ERR_LOG_MESSAGE_INVALID_FORWARD_FAILED_OPERATION_TYPE("The log message string appears to contain a failed forwarded operation but did not have a recognized operation type."),



  /**
   * The log message string appears to contain n forwarded operation but did not have a recognized operation type.
   */
  ERR_LOG_MESSAGE_INVALID_FORWARD_OPERATION_TYPE("The log message string appears to contain n forwarded operation but did not have a recognized operation type."),



  /**
   * The log message string appears to contain an operation request but did not have a recognized operation type.
   */
  ERR_LOG_MESSAGE_INVALID_REQUEST_OPERATION_TYPE("The log message string appears to contain an operation request but did not have a recognized operation type."),



  /**
   * The log message string appears to contain an operation result but did not have a recognized operation type.
   */
  ERR_LOG_MESSAGE_INVALID_RESULT_OPERATION_TYPE("The log message string appears to contain an operation result but did not have a recognized operation type."),



  /**
   * The log message string does not appear to start with a valid timestamp:  {0}
   */
  ERR_LOG_MESSAGE_INVALID_TIMESTAMP("The log message string does not appear to start with a valid timestamp:  {0}"),



  /**
   * The log message string does not appear to start with a timestamp.
   */
  ERR_LOG_MESSAGE_NO_TIMESTAMP("The log message string does not appear to start with a timestamp.");



  /**
   * The resource bundle that will be used to load the properties file.
   */
  private static final ResourceBundle RESOURCE_BUNDLE;
  static
  {
    ResourceBundle rb = null;
    try
    {
      rb = ResourceBundle.getBundle("unboundid-ldapsdk-log");
    } catch (final Exception e) {}
    RESOURCE_BUNDLE = rb;
  }



  /**
   * The map that will be used to hold the unformatted message strings, indexed by property name.
   */
  private static final ConcurrentHashMap<LogMessages,String> MESSAGE_STRINGS = new ConcurrentHashMap<LogMessages,String>();



  /**
   * The map that will be used to hold the message format objects, indexed by property name.
   */
  private static final ConcurrentHashMap<LogMessages,MessageFormat> MESSAGES = new ConcurrentHashMap<LogMessages,MessageFormat>();



  // The default text for this message
  private final String defaultText;



  /**
   * Creates a new message key.
   */
  private LogMessages(final String defaultText)
  {
    this.defaultText = defaultText;
  }



  /**
   * Retrieves a localized version of the message.
   * This method should only be used for messages which do not take any arguments.
   *
   * @return  A localized version of the message.
   */
  public String get()
  {
    String s = MESSAGE_STRINGS.get(this);
    if (s == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        return defaultText;
      }
      else
      {
        try
        {
          s = RESOURCE_BUNDLE.getString(name());
        }
        catch (final Exception e)
        {
          s = defaultText;
        }
        MESSAGE_STRINGS.putIfAbsent(this, s);
      }
    }
    return s;
  }



  /**
   * Retrieves a localized version of the message.
   *
   * @param  args  The arguments to use to format the message.
   *
   * @return  A localized version of the message.
   */
  public String get(final Object... args)
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        try
        {
          f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
        }
        catch (final Exception e)
        {
          f = new MessageFormat(defaultText);
        }
      }
      MESSAGES.putIfAbsent(this, f);
    }
    synchronized (f)
    {
      return f.format(args);
    }
  }



  /**
   * Retrieves a string representation of this message key.
   *
   * @return  A string representation of this message key.
   */
  @Override()
  public String toString()
  {
    return get();
  }
}

