/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.SearchHitDocumentTranslator;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetCollectorFactory;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetUtil;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.CommonSearchResponseAssembler;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.elasticsearch6.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchSearchResponseAssembler.class})
public class SearchSearchResponseAssemblerImpl
implements SearchSearchResponseAssembler {
    @Reference
    protected CommonSearchResponseAssembler commonSearchResponseAssembler;
    @Reference
    protected SearchHitDocumentTranslator searchHitDocumentTranslator;
    @Reference
    protected StatsTranslator statsTranslator;

    @Override
    public void assemble(SearchResponse searchResponse, SearchSearchResponse searchSearchResponse, SearchSearchRequest searchSearchRequest, String searchRequestBuilderString) {
        this.commonSearchResponseAssembler.assemble(searchResponse, (BaseSearchResponse)searchSearchResponse, searchRequestBuilderString);
        SearchHits searchHits = searchResponse.getHits();
        searchSearchResponse.setCount(searchHits.totalHits);
        this.updateFacetCollectors(searchSearchRequest.getFacets(), searchResponse);
        searchSearchResponse.setHits(this.getHits(searchSearchRequest, searchResponse, searchHits));
    }

    protected void addSnippets(Document document, Map<String, HighlightField> highlightFields, String fieldName, Locale locale) {
        String snippetFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        HighlightField highlightField = highlightFields.get(snippetFieldName);
        if (highlightField == null) {
            highlightField = highlightFields.get(fieldName);
            snippetFieldName = fieldName;
        }
        if (highlightField == null) {
            return;
        }
        Object[] array = highlightField.fragments();
        document.addText("snippet".concat("_").concat(snippetFieldName), StringUtil.merge((Object[])array, (String)"..."));
    }

    protected void addSnippets(SearchHit hit, Document document, QueryConfig queryConfig) {
        Map highlightFields = hit.getHighlightFields();
        if (MapUtil.isEmpty((Map)highlightFields)) {
            return;
        }
        for (String highlightFieldName : queryConfig.getHighlightFieldNames()) {
            this.addSnippets(document, highlightFields, highlightFieldName, queryConfig.getLocale());
        }
    }

    protected FacetCollector getFacetCollector(Facet facet, Map<String, Aggregation> aggregationsMap) {
        FacetCollectorFactory facetCollectorFactory = new FacetCollectorFactory();
        return facetCollectorFactory.getFacetCollector(aggregationsMap.get(FacetUtil.getAggregationName(facet)));
    }

    protected Hits getHits(SearchSearchRequest searchSearchRequest, SearchResponse searchResponse, SearchHits searchHits) {
        HitsImpl hits = new HitsImpl();
        TimeValue timeValue = searchResponse.getTook();
        hits.setSearchTime((float)timeValue.getSecondsFrac());
        if (searchSearchRequest.getGroupBy() != null) {
            this.updateGroupedHits(searchSearchRequest.getGroupBy(), searchResponse.getAggregations(), searchSearchRequest.getQuery(), (Hits)hits);
        }
        if (MapUtil.isNotEmpty((Map)searchSearchRequest.getStats())) {
            this.updateStatsResults(searchSearchRequest.getStats(), searchResponse, (Hits)hits);
        }
        this.processSearchHits(searchHits, searchSearchRequest.getQuery(), (Hits)hits);
        return hits;
    }

    protected void populateUID(Document document, QueryConfig queryConfig) {
        Field uidField = document.getField("uid");
        if (uidField != null) {
            return;
        }
        if (Validator.isNull((String)queryConfig.getAlternateUidFieldName())) {
            return;
        }
        String uidValue = document.get(queryConfig.getAlternateUidFieldName());
        if (Validator.isNotNull((String)uidValue)) {
            uidField = new Field("uid", uidValue);
            document.add(uidField);
        }
    }

    protected Document processSearchHit(SearchHit searchHit, QueryConfig queryConfig) {
        Document document = this.searchHitDocumentTranslator.translate(searchHit);
        this.populateUID(document, queryConfig);
        return document;
    }

    protected Hits processSearchHits(SearchHits searchHits, Query query, Hits hits) {
        ArrayList<Document> documents = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        if (searchHits.getTotalHits() > 0L) {
            SearchHit[] searchHitsArray;
            for (SearchHit searchHit : searchHitsArray = searchHits.getHits()) {
                Document document = this.processSearchHit(searchHit, query.getQueryConfig());
                documents.add(document);
                scores.add(Float.valueOf(searchHit.getScore()));
                this.addSnippets(searchHit, document, query.getQueryConfig());
            }
        }
        hits.setDocs(documents.toArray(new Document[documents.size()]));
        hits.setLength((int)searchHits.getTotalHits());
        hits.setQuery(query);
        hits.setQueryTerms(new String[0]);
        hits.setScores(ArrayUtil.toFloatArray(scores));
        return hits;
    }

    protected void updateFacetCollectors(Map<String, Facet> facets, SearchResponse searchResponse) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return;
        }
        Map aggregationsMap = aggregations.getAsMap();
        facets.forEach((facetName, facet) -> {
            if (!facet.isStatic()) {
                facet.setFacetCollector(this.getFacetCollector((Facet)facet, aggregationsMap));
            }
        });
    }

    protected void updateGroupedHits(GroupBy groupBy, Aggregations aggregations, Query query, Hits hits) {
        Map aggregationsMap = aggregations.getAsMap();
        Terms terms = (Terms)aggregationsMap.get("GroupBy_" + groupBy.getField());
        List buckets = terms.getBuckets();
        for (Terms.Bucket bucket : buckets) {
            Aggregations bucketAggregations = bucket.getAggregations();
            TopHits topHits = (TopHits)bucketAggregations.get("_topHits");
            SearchHits groupedSearchHits = topHits.getHits();
            HitsImpl groupedHits = new HitsImpl();
            this.processSearchHits(groupedSearchHits, query, (Hits)groupedHits);
            groupedHits.setLength((int)groupedSearchHits.getTotalHits());
            hits.addGroupedHits(bucket.getKeyAsString(), (Hits)groupedHits);
        }
    }

    protected void updateStatsResults(Map<String, Stats> statsMap, SearchResponse searchResponse, Hits hits) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return;
        }
        Map aggregationsMap = aggregations.getAsMap();
        for (Stats stats : statsMap.values()) {
            if (!stats.isEnabled()) continue;
            StatsResults statsResults = this.statsTranslator.translate(aggregationsMap, stats);
            hits.addStatsResults(statsResults);
        }
    }
}

