/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.CommonSearchResponseAssembler;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={CommonSearchResponseAssembler.class})
public class CommonSearchResponseAssemblerImpl
implements CommonSearchResponseAssembler {
    private static final Log _log = LogFactoryUtil.getLog(CommonSearchResponseAssemblerImpl.class);

    @Override
    public void assemble(SearchResponse searchResponse, BaseSearchResponse baseSearchResponse, String searchRequestBuilderString) {
        this.setExecutionProfile(searchResponse, baseSearchResponse);
        this.setExecutionTime(searchResponse, baseSearchResponse);
        baseSearchResponse.setSearchRequestString(searchRequestBuilderString);
        baseSearchResponse.setTerminatedEarly(searchResponse.isTerminatedEarly().booleanValue());
        baseSearchResponse.setTimedOut(searchResponse.isTimedOut());
    }

    protected String getProfileShardResultString(ProfileShardResult profileShardResult) throws IOException {
        XContentBuilder xContentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
        List queryProfileShardResults = profileShardResult.getQueryProfileResults();
        queryProfileShardResults.forEach(queryProfileShardResult -> {
            block2: {
                try {
                    xContentBuilder.startObject();
                    queryProfileShardResult.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                    xContentBuilder.endObject();
                }
                catch (IOException ioe) {
                    if (!_log.isDebugEnabled()) break block2;
                    _log.debug((Object)ioe, (Throwable)ioe);
                }
            }
        });
        return xContentBuilder.string();
    }

    protected void setExecutionProfile(SearchResponse searchResponse, BaseSearchResponse baseSearchResponse) {
        Map profileShardResults = searchResponse.getProfileResults();
        if (MapUtil.isEmpty((Map)profileShardResults)) {
            return;
        }
        HashMap executionProfile = new HashMap();
        profileShardResults.forEach((shardKey, profileShardResult) -> {
            block2: {
                try {
                    executionProfile.put(shardKey, this.getProfileShardResultString((ProfileShardResult)profileShardResult));
                }
                catch (IOException ioe) {
                    if (!_log.isInfoEnabled()) break block2;
                    _log.info((Object)ioe, (Throwable)ioe);
                }
            }
        });
        baseSearchResponse.setExecutionProfile(executionProfile);
    }

    protected void setExecutionTime(SearchResponse searchResponse, BaseSearchResponse baseSearchResponse) {
        TimeValue tookTimeValue = searchResponse.getTook();
        baseSearchResponse.setExecutionTime(tookTimeValue.getMillis());
    }
}

