/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterTranslator;
import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.CommonSearchRequestBuilderAssembler;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommonSearchRequestBuilderAssembler.class})
public class CommonSearchRequestBuilderAssemblerImpl
implements CommonSearchRequestBuilderAssembler {
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected FilterTranslator<QueryBuilder> filterTranslator;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected QueryTranslator<QueryBuilder> queryTranslator;

    @Override
    public void assemble(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest searchSearchRequest) {
        searchRequestBuilder.setIndices(searchSearchRequest.getIndexNames());
        if (searchSearchRequest.getMinimumScore() > 0.0f) {
            searchRequestBuilder.setMinScore(searchSearchRequest.getMinimumScore());
        }
        if (searchSearchRequest.getPostFilter() != null) {
            QueryBuilder postFilterQueryBuilder = (QueryBuilder)this.filterTranslator.translate(searchSearchRequest.getPostFilter(), null);
            searchRequestBuilder.setPostFilter(postFilterQueryBuilder);
        }
        searchRequestBuilder.setQuery(this.getQueryBuilder(searchSearchRequest));
        if (searchSearchRequest.isRequestCache()) {
            searchRequestBuilder.setRequestCache(Boolean.valueOf(searchSearchRequest.isRequestCache()));
        }
        if (searchSearchRequest.getTimeoutInMilliseconds() > 0L) {
            searchRequestBuilder.setTimeout(TimeValue.timeValueMillis((long)searchSearchRequest.getTimeoutInMilliseconds()));
        }
        searchRequestBuilder.setTrackTotalHits(searchSearchRequest.isTrackTotalHits());
    }

    protected QueryBuilder getQueryBuilder(BaseSearchRequest searchSearchRequest) {
        Query query = searchSearchRequest.getQuery();
        QueryBuilder queryBuilder = (QueryBuilder)this.queryTranslator.translate(query, null);
        if (query.getPreBooleanFilter() == null) {
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)this.filterTranslator.translate((Filter)query.getPreBooleanFilter(), null));
        boolQueryBuilder.must(queryBuilder);
        return boolQueryBuilder;
    }
}

