/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.GetFieldMappingIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.GetFieldMappingIndexRequest;
import com.liferay.portal.search.engine.adapter.index.GetFieldMappingIndexResponse;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GetFieldMappingIndexRequestExecutor.class})
public class GetFieldMappingIndexRequestExecutorImpl
implements GetFieldMappingIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public GetFieldMappingIndexResponse execute(GetFieldMappingIndexRequest getFieldMappingIndexRequest) {
        GetFieldMappingsRequestBuilder getFieldMappingsRequestBuilder = this.createGetFieldMappingsRequestBuilder(getFieldMappingIndexRequest);
        GetFieldMappingsResponse getFieldMappingsResponse = (GetFieldMappingsResponse)getFieldMappingsRequestBuilder.get();
        Map mappings = getFieldMappingsResponse.mappings();
        HashMap<String, String> fieldMappings = new HashMap<String, String>();
        for (String indexName : getFieldMappingIndexRequest.getIndexNames()) {
            Map map1 = (Map)mappings.get(indexName);
            Map map2 = (Map)map1.get(getFieldMappingIndexRequest.getMappingName());
            fieldMappings.put(indexName, map2.toString());
        }
        return new GetFieldMappingIndexResponse(fieldMappings);
    }

    protected GetFieldMappingsRequestBuilder createGetFieldMappingsRequestBuilder(GetFieldMappingIndexRequest getFieldMappingIndexRequest) {
        AdminClient adminClient = this.elasticsearchConnectionManager.getAdminClient();
        IndicesAdminClient indicesAdminClient = adminClient.indices();
        GetFieldMappingsRequestBuilder getFieldMappingsRequestBuilder = indicesAdminClient.prepareGetFieldMappings(getFieldMappingIndexRequest.getIndexNames());
        getFieldMappingsRequestBuilder.setFields(getFieldMappingIndexRequest.getFields());
        getFieldMappingsRequestBuilder.setTypes(new String[]{getFieldMappingIndexRequest.getMappingName()});
        return getFieldMappingsRequestBuilder;
    }
}

